/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.sort;

import java.util.Map;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.script.NumberSortScript;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;
import org.opensearch.sql.opensearch.storage.script.core.CalciteScript;

public class CalciteNumberSortScript
extends NumberSortScript {
    private final CalciteScript calciteScript;
    private final SourceLookup sourceLookup;
    private final boolean missingMax;
    private final Map<String, Integer> parametersToIndex;

    public CalciteNumberSortScript(Function1<DataContext, Object[]> function, SearchLookup lookup, LeafReaderContext context, Map<String, Object> params, Map<String, Integer> parametersToIndex) {
        super(params, lookup, context);
        this.calciteScript = new CalciteScript(function, params);
        this.sourceLookup = lookup.getLeafSearchLookup(context).source();
        this.parametersToIndex = parametersToIndex;
        this.missingMax = (Boolean)params.getOrDefault("MISSING_MAX", false);
    }

    public double execute() {
        Object value = this.calciteScript.execute(this.getDoc(), this.sourceLookup, this.parametersToIndex)[0];
        if (value == null) {
            return this.missingMax ? Double.NaN : Double.NEGATIVE_INFINITY;
        }
        return ((Number)value).doubleValue();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalciteNumberSortScript)) {
            return false;
        }
        CalciteNumberSortScript other = (CalciteNumberSortScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.missingMax != other.missingMax) {
            return false;
        }
        CalciteScript this$calciteScript = this.calciteScript;
        CalciteScript other$calciteScript = other.calciteScript;
        if (this$calciteScript == null ? other$calciteScript != null : !((Object)this$calciteScript).equals(other$calciteScript)) {
            return false;
        }
        SourceLookup this$sourceLookup = this.sourceLookup;
        SourceLookup other$sourceLookup = other.sourceLookup;
        if (this$sourceLookup == null ? other$sourceLookup != null : !this$sourceLookup.equals(other$sourceLookup)) {
            return false;
        }
        Map<String, Integer> this$parametersToIndex = this.parametersToIndex;
        Map<String, Integer> other$parametersToIndex = other.parametersToIndex;
        return !(this$parametersToIndex == null ? other$parametersToIndex != null : !((Object)this$parametersToIndex).equals(other$parametersToIndex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalciteNumberSortScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.missingMax ? 79 : 97);
        CalciteScript $calciteScript = this.calciteScript;
        result = result * 59 + ($calciteScript == null ? 43 : ((Object)$calciteScript).hashCode());
        SourceLookup $sourceLookup = this.sourceLookup;
        result = result * 59 + ($sourceLookup == null ? 43 : $sourceLookup.hashCode());
        Map<String, Integer> $parametersToIndex = this.parametersToIndex;
        result = result * 59 + ($parametersToIndex == null ? 43 : ((Object)$parametersToIndex).hashCode());
        return result;
    }
}

