/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr;

import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.legacy.antlr.SqlAnalysisConfig;
import org.opensearch.sql.legacy.antlr.parser.OpenSearchLegacySqlLexer;
import org.opensearch.sql.legacy.antlr.parser.OpenSearchLegacySqlParser;
import org.opensearch.sql.legacy.antlr.semantic.scope.SemanticContext;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.visitor.OpenSearchMappingLoader;
import org.opensearch.sql.legacy.antlr.semantic.visitor.SemanticAnalyzer;
import org.opensearch.sql.legacy.antlr.semantic.visitor.TypeChecker;
import org.opensearch.sql.legacy.antlr.syntax.CaseInsensitiveCharStream;
import org.opensearch.sql.legacy.antlr.syntax.SyntaxAnalysisErrorListener;
import org.opensearch.sql.legacy.antlr.visitor.AntlrSqlParseTreeVisitor;
import org.opensearch.sql.legacy.antlr.visitor.EarlyExitAnalysisException;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;

public class OpenSearchLegacySqlAnalyzer {
    private static final Logger LOG = LogManager.getLogger();
    private final SqlAnalysisConfig config;

    public OpenSearchLegacySqlAnalyzer(SqlAnalysisConfig config) {
        this.config = config;
    }

    public Optional<Type> analyze(String sql, LocalClusterState clusterState) {
        if (!this.isSelectStatement(sql) || !this.config.isAnalyzerEnabled()) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.analyzeSemantic(this.analyzeSyntax(sql), clusterState));
        }
        catch (EarlyExitAnalysisException e) {
            LOG.debug("Analysis exits early and will skip remaining process", (Throwable)e);
            return Optional.empty();
        }
    }

    public ParseTree analyzeSyntax(String sql) {
        OpenSearchLegacySqlParser parser = this.createParser(this.createLexer(sql));
        parser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        return parser.root();
    }

    public Type analyzeSemantic(ParseTree tree, LocalClusterState clusterState) {
        return (Type)tree.accept(new AntlrSqlParseTreeVisitor<Type>(this.createAnalyzer(clusterState)));
    }

    private SemanticAnalyzer createAnalyzer(LocalClusterState clusterState) {
        SemanticContext context = new SemanticContext();
        OpenSearchMappingLoader mappingLoader = new OpenSearchMappingLoader(context, clusterState, this.config.getAnalysisThreshold());
        TypeChecker typeChecker = new TypeChecker(context, this.config.isFieldSuggestionEnabled());
        return new SemanticAnalyzer(mappingLoader, typeChecker);
    }

    private OpenSearchLegacySqlParser createParser(Lexer lexer) {
        return new OpenSearchLegacySqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
    }

    private OpenSearchLegacySqlLexer createLexer(String sql) {
        return new OpenSearchLegacySqlLexer(new CaseInsensitiveCharStream(sql));
    }

    private boolean isSelectStatement(String sql) {
        int endOfFirstWord = (sql = sql.replaceAll("\\R", " ").trim()).indexOf(32);
        String firstWord = sql.substring(0, endOfFirstWord > 0 ? endOfFirstWord : sql.length());
        return "SELECT".equalsIgnoreCase(firstWord);
    }
}

