/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning;

import lombok.Generated;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.exception.SemanticCheckException;

public class BinnableField {
    private final RexNode fieldExpr;
    private final RelDataType fieldType;
    private final String fieldName;
    private final boolean isTimeBased;
    private final boolean isNumeric;

    public BinnableField(RexNode fieldExpr, RelDataType fieldType, String fieldName) {
        this.fieldExpr = fieldExpr;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isTimeBased = OpenSearchTypeFactory.isTimeBasedType(fieldType);
        this.isNumeric = OpenSearchTypeFactory.isNumericType(fieldType);
        if (!this.isNumeric && !this.isTimeBased) {
            throw new SemanticCheckException(String.format("Cannot apply binning to field '%s': unsupported type", fieldName));
        }
    }

    public boolean requiresNumericBinning() {
        return !this.isTimeBased;
    }

    @Generated
    public RexNode getFieldExpr() {
        return this.fieldExpr;
    }

    @Generated
    public RelDataType getFieldType() {
        return this.fieldType;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public boolean isTimeBased() {
        return this.isTimeBased;
    }

    @Generated
    public boolean isNumeric() {
        return this.isNumeric;
    }
}

