/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import javax.annotation.Nullable;
import lombok.Generated;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;

public class CountBin
extends Bin {
    private final Integer bins;
    @Nullable
    private final UnresolvedExpression start;
    @Nullable
    private final UnresolvedExpression end;

    public CountBin(UnresolvedExpression field, @Nullable String alias, Integer bins, @Nullable UnresolvedExpression start, @Nullable UnresolvedExpression end) {
        super(field, alias);
        this.bins = bins;
        this.start = start;
        this.end = end;
        this.validate();
    }

    @Override
    public void validate() {
        if (this.bins < 2 || this.bins > 50000) {
            throw new IllegalArgumentException(String.format("The bins parameter must be between %d and %d, got: %d", 2, 50000, this.bins));
        }
    }

    @Generated
    public static CountBinBuilder builder() {
        return new CountBinBuilder();
    }

    @Generated
    public Integer getBins() {
        return this.bins;
    }

    @Nullable
    @Generated
    public UnresolvedExpression getStart() {
        return this.start;
    }

    @Nullable
    @Generated
    public UnresolvedExpression getEnd() {
        return this.end;
    }

    @Override
    @Generated
    public String toString() {
        return "CountBin(super=" + super.toString() + ", bins=" + this.getBins() + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountBin)) {
            return false;
        }
        CountBin other = (CountBin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$bins = this.getBins();
        Integer other$bins = other.getBins();
        if (this$bins == null ? other$bins != null : !((Object)this$bins).equals(other$bins)) {
            return false;
        }
        UnresolvedExpression this$start = this.getStart();
        UnresolvedExpression other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        UnresolvedExpression this$end = this.getEnd();
        UnresolvedExpression other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CountBin;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $bins = this.getBins();
        result = result * 59 + ($bins == null ? 43 : ((Object)$bins).hashCode());
        UnresolvedExpression $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        UnresolvedExpression $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public static class CountBinBuilder {
        @Generated
        private UnresolvedExpression field;
        @Generated
        private String alias;
        @Generated
        private Integer bins;
        @Generated
        private UnresolvedExpression start;
        @Generated
        private UnresolvedExpression end;

        @Generated
        CountBinBuilder() {
        }

        @Generated
        public CountBinBuilder field(UnresolvedExpression field) {
            this.field = field;
            return this;
        }

        @Generated
        public CountBinBuilder alias(@Nullable String alias) {
            this.alias = alias;
            return this;
        }

        @Generated
        public CountBinBuilder bins(Integer bins) {
            this.bins = bins;
            return this;
        }

        @Generated
        public CountBinBuilder start(@Nullable UnresolvedExpression start) {
            this.start = start;
            return this;
        }

        @Generated
        public CountBinBuilder end(@Nullable UnresolvedExpression end) {
            this.end = end;
            return this;
        }

        @Generated
        public CountBin build() {
            return new CountBin(this.field, this.alias, this.bins, this.start, this.end);
        }

        @Generated
        public String toString() {
            return "CountBin.CountBinBuilder(field=" + String.valueOf(this.field) + ", alias=" + this.alias + ", bins=" + this.bins + ", start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ")";
        }
    }
}

