/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.searchrelevance.scheduler.ExperimentCancellationToken;
import org.opensearch.searchrelevance.scheduler.SearchRelevanceJobRunner;
import org.opensearch.threadpool.ThreadPool;

public class ConcurrencyUtil {
    private static final Logger log = LogManager.getLogger(SearchRelevanceJobRunner.class);

    public static <T> CompletableFuture<T> withTimeout(CompletableFuture<T> future, long timeoutSeconds, ExperimentCancellationToken cancellationToken, CountDownLatch actuallyFinished, ThreadPool threadPool) {
        CompletableFuture timeoutFuture = new CompletableFuture();
        ScheduledFuture<?> timeout = threadPool.scheduler().schedule(() -> {
            cancellationToken.cancel();
            FutureUtils.cancel((Future)future);
            timeoutFuture.completeExceptionally(new TimeoutException());
        }, timeoutSeconds, TimeUnit.SECONDS);
        future.whenComplete((result, throwable) -> {
            try {
                actuallyFinished.await();
            }
            catch (Exception e) {
                log.error("Somehow the thread waiting for the experiment run and all the async tasks to complete was interrupted.");
            }
            FutureUtils.cancel((Future)timeout);
            if (throwable == null) {
                timeoutFuture.complete(result);
            } else {
                timeoutFuture.completeExceptionally((Throwable)throwable);
            }
        });
        return timeoutFuture;
    }
}

