/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.indices;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseSections;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.Streams;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.internal.InternalSearchResponse;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.shared.StashedThreadContext;
import org.opensearch.transport.client.Client;
import reactor.util.annotation.NonNull;

public class SearchRelevanceIndicesManager {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchRelevanceIndicesManager.class);
    private final ClusterService clusterService;
    private final Client client;

    public SearchRelevanceIndicesManager(@NonNull ClusterService clusterService, @NonNull Client client) {
        this.clusterService = clusterService;
        this.client = client;
    }

    public void createIndexIfAbsent(SearchRelevanceIndices index, final StepListener<Void> stepListener) {
        final String indexName = index.getIndexName();
        String mapping = index.getMapping();
        if (this.clusterService.state().metadata().hasIndex(indexName)) {
            log.debug("Index [{}] already exists, skipping creation", (Object)indexName);
            stepListener.onResponse(null);
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).mapping(mapping);
        StashedThreadContext.run(this.client, () -> this.client.admin().indices().create(createIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(this){

            public void onResponse(CreateIndexResponse createIndexResponse) {
                log.info("Successfully created index [{}]", (Object)indexName);
                stepListener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    log.debug("index[{}] already exist", (Object)indexName);
                    stepListener.onResponse(null);
                    return;
                }
                log.warn("Failed to create index [{}] - continuing without cache optimization", (Object)indexName);
                stepListener.onResponse(null);
            }
        }));
    }

    private void createIndexIfAbsentSync(SearchRelevanceIndices index) {
        String indexName = index.getIndexName();
        String mapping = index.getMapping();
        if (this.clusterService.state().metadata().hasIndex(indexName)) {
            log.debug("Index [{}] already exists, skipping creation", (Object)indexName);
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).mapping(mapping);
        StashedThreadContext.run(this.client, () -> this.client.admin().indices().create(createIndexRequest));
    }

    public SearchResponse getDocByDocIdSync(String docId, SearchRelevanceIndices index) {
        SearchRequest searchRequest = new SearchRequest(new String[]{index.getIndexName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)docId)).size(1);
        searchRequest.source(sourceBuilder);
        return (SearchResponse)this.client.search(searchRequest).actionGet();
    }

    public void putDoc(String docId, XContentBuilder xContentBuilder, SearchRelevanceIndices index, ActionListener<?> listener) {
        this.putDocWithRefreshPolicy(docId, xContentBuilder, index, WriteRequest.RefreshPolicy.IMMEDIATE, listener);
    }

    public void putDocEfficient(String docId, XContentBuilder xContentBuilder, SearchRelevanceIndices index, ActionListener<?> listener) {
        this.putDocWithRefreshPolicy(docId, xContentBuilder, index, WriteRequest.RefreshPolicy.WAIT_UNTIL, listener);
    }

    public void putDocWithRefreshPolicy(String docId, XContentBuilder xContentBuilder, SearchRelevanceIndices index, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<?> listener) {
        SearchOperationContext searchOperationContext = SearchOperationContext.builder().documentId(docId).xContentBuilder(xContentBuilder).index(index).build();
        BiConsumer<SearchOperationContext, ActionListener<?>> action = (context, actionListener) -> StashedThreadContext.run(this.client, () -> {
            try {
                ActionListener typedListener = actionListener;
                ((IndexRequestBuilder)this.client.prepareIndex(context.getIndex().getIndexName()).setId(context.getDocumentId()).setOpType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(refreshPolicy)).setSource(context.getXContentBuilder()).execute(typedListener);
            }
            catch (Exception e) {
                throw new SearchRelevanceException("Failed to store doc", e, RestStatus.INTERNAL_SERVER_ERROR);
            }
        });
        this.executeAction(listener, searchOperationContext, action);
    }

    public void updateDoc(String docId, XContentBuilder xContentBuilder, SearchRelevanceIndices index, ActionListener listener) {
        this.updateDocWithRefreshPolicy(docId, xContentBuilder, index, WriteRequest.RefreshPolicy.IMMEDIATE, listener);
    }

    public void updateDocEfficient(String docId, XContentBuilder xContentBuilder, SearchRelevanceIndices index, ActionListener listener) {
        this.updateDocWithRefreshPolicy(docId, xContentBuilder, index, WriteRequest.RefreshPolicy.WAIT_UNTIL, listener);
    }

    public void updateDocWithRefreshPolicy(String docId, XContentBuilder xContentBuilder, SearchRelevanceIndices index, WriteRequest.RefreshPolicy refreshPolicy, ActionListener listener) {
        SearchOperationContext searchOperationContext = SearchOperationContext.builder().index(index).xContentBuilder(xContentBuilder).documentId(docId).build();
        BiConsumer<SearchOperationContext, ActionListener<?>> action = (searchOperationContext1, actionListener) -> StashedThreadContext.run(this.client, () -> {
            try {
                ((IndexRequestBuilder)this.client.prepareIndex(searchOperationContext1.getIndex().getIndexName()).setId(searchOperationContext1.getDocumentId()).setOpType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(refreshPolicy)).setSource(searchOperationContext1.getXContentBuilder()).execute(actionListener);
            }
            catch (Exception e) {
                throw new SearchRelevanceException("Failed to store doc", e, RestStatus.INTERNAL_SERVER_ERROR);
            }
        });
        this.executeAction(listener, searchOperationContext, action);
    }

    public void deleteDocByDocId(String docId, SearchRelevanceIndices index, ActionListener<DeleteResponse> listener) {
        SearchOperationContext searchOperationContext = SearchOperationContext.builder().index(index).documentId(docId).build();
        BiConsumer<SearchOperationContext, ActionListener<?>> action = (searchOperationContextArg, actionListener) -> StashedThreadContext.run(this.client, () -> {
            try {
                final ActionListener typedListener = actionListener;
                ((DeleteRequestBuilder)this.client.prepareDelete(searchOperationContext.getIndex().getIndexName(), searchOperationContext.getDocumentId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute((ActionListener)new ActionListener<DeleteResponse>(this){

                    public void onResponse(DeleteResponse deleteResponse) {
                        typedListener.onResponse((Object)deleteResponse);
                    }

                    public void onFailure(Exception e) {
                        typedListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to delete doc", e, RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                });
            }
            catch (Exception e) {
                actionListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to delete doc", e, RestStatus.INTERNAL_SERVER_ERROR)));
            }
        });
        this.executeAction(listener, searchOperationContext, action);
    }

    public SearchResponse getDocByDocId(String docId, SearchRelevanceIndices index, ActionListener<?> listener) {
        SearchOperationContext searchOperationContext = SearchOperationContext.builder().index(index).documentId(docId).build();
        BiConsumer<SearchOperationContext, ActionListener<?>> action = (searchOperationContextArg, actionListener) -> {
            SearchRequest searchRequest = new SearchRequest(new String[]{searchOperationContextArg.getIndex().getIndexName()});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)searchOperationContextArg.getDocumentId())).size(1);
            searchRequest.source(sourceBuilder);
            StashedThreadContext.run(this.client, () -> {
                try {
                    final ActionListener typedListener = actionListener;
                    this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){

                        public void onResponse(SearchResponse response) {
                            log.info("Successfully get doc id [{}]", (Object)searchOperationContextArg.getDocumentId());
                            if (response.getHits().getTotalHits().value() == 0L) {
                                typedListener.onFailure((Exception)new ResourceNotFoundException("Document not found: " + searchOperationContextArg.getDocumentId(), new Object[]{RestStatus.NOT_FOUND}));
                                return;
                            }
                            typedListener.onResponse((Object)response);
                        }

                        public void onFailure(Exception e) {
                            actionListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to get document", e, RestStatus.INTERNAL_SERVER_ERROR)));
                        }
                    });
                }
                catch (Exception e) {
                    actionListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to get doc", e, RestStatus.INTERNAL_SERVER_ERROR)));
                }
            });
        };
        this.executeAction(listener, searchOperationContext, action);
        return null;
    }

    public SearchResponse listDocsBySearchRequest(SearchSourceBuilder searchSourceBuilder, SearchRelevanceIndices index, ActionListener<SearchResponse> listener) {
        SearchOperationContext searchOperationContext = SearchOperationContext.builder().searchSourceBuilder(searchSourceBuilder).index(index).build();
        BiConsumer<SearchOperationContext, ActionListener<?>> action = (context, actionListener) -> {
            final SearchRequest searchRequest = new SearchRequest(new String[]{context.getIndex().getIndexName()});
            searchRequest.source(context.getSearchSourceBuilder());
            StashedThreadContext.run(this.client, () -> {
                try {
                    this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                        public void onResponse(SearchResponse response) {
                            log.info("Successfully list documents with search request [{}]", (Object)searchRequest);
                            actionListener.onResponse((Object)response);
                        }

                        public void onFailure(Exception e) {
                            if (e instanceof IndexNotFoundException) {
                                InternalSearchResponse internalSearchResponse = InternalSearchResponse.empty();
                                SearchResponse emptySearchResponse = new SearchResponse((SearchResponseSections)internalSearchResponse, null, 0, 0, 0, 0L, null, new ShardSearchFailure[0], SearchResponse.Clusters.EMPTY, null);
                                actionListener.onResponse((Object)emptySearchResponse);
                            } else {
                                actionListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to list documents", e, RestStatus.INTERNAL_SERVER_ERROR)));
                            }
                        }
                    });
                }
                catch (Exception e) {
                    actionListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to list docs", e, RestStatus.INTERNAL_SERVER_ERROR)));
                }
            });
        };
        this.executeAction(listener, searchOperationContext, action);
        return null;
    }

    public void deleteByQuery(String fieldId, String fieldName, SearchRelevanceIndices index, ActionListener<BulkByScrollResponse> listener) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{index.getIndexName()});
        deleteByQueryRequest.setConflicts("proceed");
        deleteByQueryRequest.setBatchSize(1000);
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)fieldId));
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
    }

    public static String getIndexMappings(String mapping) throws IOException {
        if (mapping == null || mapping.trim().isEmpty()) {
            throw new SearchRelevanceException("Mapping path cannot be null or empty", RestStatus.INTERNAL_SERVER_ERROR);
        }
        Object path = mapping.startsWith("/") ? mapping : "/" + mapping;
        try (InputStream is = SearchRelevanceIndicesManager.class.getResourceAsStream((String)path);){
            if (is == null) {
                throw new FileNotFoundException("Resource [" + (String)path + "] not found in classpath");
            }
            StringBuilder sb = new StringBuilder();
            Streams.readAllLines((InputStream)is, sb::append);
            String string = sb.toString();
            return string;
        }
    }

    private void executeAction(ActionListener<?> listener, SearchOperationContext searchOperationContext, BiConsumer<SearchOperationContext, ActionListener<?>> action) {
        SearchRelevanceIndices index = searchOperationContext.getIndex();
        if (Objects.isNull((Object)index)) {
            throw new SearchRelevanceException("index cannot be null", RestStatus.BAD_REQUEST);
        }
        if (index.isProtected()) {
            this.executeWithIndexCreationAsynchronizedMode(searchOperationContext, action, listener);
        } else {
            this.executeWithIndexCreationSynchronizedMode(searchOperationContext, action, listener);
        }
    }

    private <T> void executeWithIndexCreationSynchronizedMode(SearchOperationContext context, BiConsumer<SearchOperationContext, ActionListener<?>> action, ActionListener<T> listener) {
        this.createIndexIfAbsentSync(context.getIndex());
        action.accept(context, listener);
    }

    private <T> void executeWithIndexCreationAsynchronizedMode(SearchOperationContext context, BiConsumer<SearchOperationContext, ActionListener<?>> action, ActionListener<T> listener) {
        StepListener createIndexStep = new StepListener();
        this.createIndexIfAbsent(context.getIndex(), (StepListener<Void>)createIndexStep);
        createIndexStep.whenComplete(v -> action.accept(context, listener), e -> {
            throw e instanceof RuntimeException ? (RuntimeException)e : new IllegalStateException((Throwable)e);
        });
    }

    static class SearchOperationContext {
        private final SearchRelevanceIndices index;
        private final SearchSourceBuilder searchSourceBuilder;
        private final XContentBuilder xContentBuilder;
        private final String documentId;

        @Generated
        SearchOperationContext(SearchRelevanceIndices index, SearchSourceBuilder searchSourceBuilder, XContentBuilder xContentBuilder, String documentId) {
            this.index = index;
            this.searchSourceBuilder = searchSourceBuilder;
            this.xContentBuilder = xContentBuilder;
            this.documentId = documentId;
        }

        @Generated
        public static SearchOperationContextBuilder builder() {
            return new SearchOperationContextBuilder();
        }

        @Generated
        public SearchRelevanceIndices getIndex() {
            return this.index;
        }

        @Generated
        public SearchSourceBuilder getSearchSourceBuilder() {
            return this.searchSourceBuilder;
        }

        @Generated
        public XContentBuilder getXContentBuilder() {
            return this.xContentBuilder;
        }

        @Generated
        public String getDocumentId() {
            return this.documentId;
        }

        @Generated
        public static class SearchOperationContextBuilder {
            @Generated
            private SearchRelevanceIndices index;
            @Generated
            private SearchSourceBuilder searchSourceBuilder;
            @Generated
            private XContentBuilder xContentBuilder;
            @Generated
            private String documentId;

            @Generated
            SearchOperationContextBuilder() {
            }

            @Generated
            public SearchOperationContextBuilder index(SearchRelevanceIndices index) {
                this.index = index;
                return this;
            }

            @Generated
            public SearchOperationContextBuilder searchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
                this.searchSourceBuilder = searchSourceBuilder;
                return this;
            }

            @Generated
            public SearchOperationContextBuilder xContentBuilder(XContentBuilder xContentBuilder) {
                this.xContentBuilder = xContentBuilder;
                return this;
            }

            @Generated
            public SearchOperationContextBuilder documentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            @Generated
            public SearchOperationContext build() {
                return new SearchOperationContext(this.index, this.searchSourceBuilder, this.xContentBuilder, this.documentId);
            }

            @Generated
            public String toString() {
                return "SearchRelevanceIndicesManager.SearchOperationContext.SearchOperationContextBuilder(index=" + String.valueOf((Object)this.index) + ", searchSourceBuilder=" + String.valueOf(this.searchSourceBuilder) + ", xContentBuilder=" + String.valueOf(this.xContentBuilder) + ", documentId=" + this.documentId + ")";
            }
        }
    }
}

