/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.ScheduledJob;

public class ScheduledJobsDao {
    private static final Logger LOGGER = LogManager.getLogger(ScheduledJobsDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    public ScheduledJobsDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.SCHEDULED_JOBS, stepListener);
    }

    public void putScheduledJob(ScheduledJob scheduledJob, ActionListener listener) {
        if (scheduledJob == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Scheduled job cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(scheduledJob.getId(), scheduledJob.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.SCHEDULED_JOBS, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store scheduled job", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void updateScheduledJob(ScheduledJob scheduledJob, ActionListener listener) {
        if (scheduledJob == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Scheduled job cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.updateDoc(scheduledJob.getId(), scheduledJob.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.SCHEDULED_JOBS, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store scheduled job", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteScheduledJob(String scheduledJobId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(scheduledJobId, SearchRelevanceIndices.SCHEDULED_JOBS, listener);
    }

    public SearchResponse getScheduledJob(String scheduledJobId, ActionListener<SearchResponse> listener) {
        if (scheduledJobId == null || scheduledJobId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("jobId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(scheduledJobId, SearchRelevanceIndices.SCHEDULED_JOBS, listener);
    }

    public SearchResponse listScheduledJob(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.SCHEDULED_JOBS, listener);
    }
}

