/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.Experiment;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.stats.events.EventStatName;
import org.opensearch.searchrelevance.stats.events.EventStatsManager;

public class ExperimentDao {
    private static final Logger LOGGER = LogManager.getLogger(ExperimentDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;
    private static Map<ExperimentType, Runnable> experimentTypeIncrementers = Map.of(ExperimentType.PAIRWISE_COMPARISON, () -> EventStatsManager.increment(EventStatName.EXPERIMENT_PAIRWISE_COMPARISON_EXECUTIONS), ExperimentType.POINTWISE_EVALUATION, () -> EventStatsManager.increment(EventStatName.EXPERIMENT_POINTWISE_EVALUATION_EXECUTIONS), ExperimentType.HYBRID_OPTIMIZER, () -> EventStatsManager.increment(EventStatName.EXPERIMENT_HYBRID_OPTIMIZER_EXECUTIONS));

    public ExperimentDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.EXPERIMENT, stepListener);
    }

    public void putExperiment(Experiment experiment, ActionListener listener) {
        if (experiment == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        this.recordStats(experiment);
        try {
            this.searchRelevanceIndicesManager.putDoc(experiment.id(), experiment.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.EXPERIMENT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store experiment", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void updateExperiment(Experiment experiment, ActionListener listener) {
        if (experiment == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.updateDoc(experiment.id(), experiment.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.EXPERIMENT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store experiment", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteExperiment(String experimentId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(experimentId, SearchRelevanceIndices.EXPERIMENT, listener);
    }

    public SearchResponse getExperiment(String experimentId, ActionListener<SearchResponse> listener) {
        if (experimentId == null || experimentId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("experimentId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(experimentId, SearchRelevanceIndices.EXPERIMENT, listener);
    }

    public void getExperimentByFieldId(String fieldId, String fieldName, int size, ActionListener<SearchResponse> listener) {
        if (fieldId == null || fieldId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("fieldId cannot be null or empty", RestStatus.BAD_REQUEST)));
            return;
        }
        if (fieldName == null || fieldName.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("fieldName cannot be null or empty", RestStatus.BAD_REQUEST)));
            return;
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)fieldId)).size(size);
        this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.EXPERIMENT, listener);
    }

    public SearchResponse listExperiment(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.EXPERIMENT, listener);
    }

    private void recordStats(Experiment experiment) {
        EventStatsManager.increment(EventStatName.EXPERIMENT_EXECUTIONS);
        Optional.ofNullable(experimentTypeIncrementers.get((Object)experiment.type())).ifPresent(Runnable::run);
    }
}

