/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.util.Optional;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.ratelimit.QueuedRequest;
import org.opensearch.timeseries.ratelimit.RequestPriority;

public class FeatureRequest
extends QueuedRequest {
    private final double[] currentFeature;
    private final long dataStartTimeMillis;
    protected final String modelId;
    private final Optional<Entity> entity;
    private final String taskId;

    public FeatureRequest(long expirationEpochMs, String configId, RequestPriority priority, double[] currentFeature, long dataStartTimeMs, Entity entity, String taskId) {
        super(expirationEpochMs, configId, priority);
        this.currentFeature = currentFeature;
        this.dataStartTimeMillis = dataStartTimeMs;
        this.modelId = entity.getModelId(configId).isEmpty() ? null : entity.getModelId(configId).get();
        this.entity = Optional.ofNullable(entity);
        this.taskId = taskId;
    }

    public FeatureRequest(long expirationEpochMs, String configId, RequestPriority priority, String modelId, double[] currentFeature, long dataStartTimeMs, String taskId) {
        super(expirationEpochMs, configId, priority);
        this.currentFeature = currentFeature;
        this.dataStartTimeMillis = dataStartTimeMs;
        this.modelId = modelId;
        this.entity = Optional.empty();
        this.taskId = taskId;
    }

    public double[] getCurrentFeature() {
        return this.currentFeature;
    }

    public long getDataStartTimeMillis() {
        return this.dataStartTimeMillis;
    }

    public String getModelId() {
        return this.modelId;
    }

    public Optional<Entity> getEntity() {
        return this.entity;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean isRunOnce() {
        return this.taskId != null;
    }
}

