/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.FilterBy;
import org.opensearch.forecast.model.Subaggregation;
import org.opensearch.forecast.transport.BuildInQuery;
import org.opensearch.forecast.transport.RelationalOperation;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.util.ParseUtils;

public class SearchTopForecastResultRequest
extends ActionRequest
implements ToXContentObject {
    private static final String TASK_ID_FIELD = "task_id";
    private static final String SIZE_FIELD = "size";
    private static final String SPLIT_BY_FIELD = "split_by";
    private static final String FILTER_BY_FIELD = "filter_by";
    private static final String BUILD_IN_QUERY_FIELD = "build_in_query";
    private static final String THRESHOLD_FIELD = "threshold";
    private static final String RELATION_TO_THRESHOLD_FIELD = "relation_to_threshold";
    private static final String FILTER_QUERY_FIELD = "filter_query";
    public static final String SUBAGGREGATIONS_FIELD = "subaggregations";
    private static final String FORECAST_FROM_FIELD = "forecast_from";
    private static final String RUN_ONCE_FIELD = "run_once";
    private String forecasterId;
    private String taskId;
    private boolean runOnce;
    private Integer size;
    private List<String> splitBy;
    private FilterBy filterBy;
    private BuildInQuery buildInQuery;
    private Float threshold;
    private RelationalOperation relationToThreshold;
    private QueryBuilder filterQuery;
    private List<Subaggregation> subaggregations;
    private Instant forecastFrom;

    public SearchTopForecastResultRequest(StreamInput in) throws IOException {
        super(in);
        this.forecasterId = in.readOptionalString();
        this.taskId = in.readOptionalString();
        this.runOnce = in.readBoolean();
        this.size = in.readOptionalInt();
        this.splitBy = in.readOptionalStringList();
        this.filterBy = in.readBoolean() ? (FilterBy)in.readEnum(FilterBy.class) : null;
        this.buildInQuery = in.readBoolean() ? (BuildInQuery)in.readEnum(BuildInQuery.class) : null;
        this.threshold = in.readOptionalFloat();
        this.relationToThreshold = in.readBoolean() ? (RelationalOperation)in.readEnum(RelationalOperation.class) : null;
        this.filterQuery = in.readBoolean() ? (QueryBuilder)in.readNamedWriteable(QueryBuilder.class) : null;
        this.subaggregations = in.readBoolean() ? in.readList(Subaggregation::new) : null;
        this.forecastFrom = in.readOptionalInstant();
    }

    public SearchTopForecastResultRequest(String forecasterId, String taskId, boolean runOnce, Integer size, List<String> splitBy, FilterBy filterBy, BuildInQuery buildInQuery, Float threshold, RelationalOperation relationToThreshold, QueryBuilder filterQuery, List<Subaggregation> subaggregations, Instant forecastFrom) {
        this.forecasterId = forecasterId;
        this.taskId = taskId;
        this.runOnce = runOnce;
        this.size = size;
        this.splitBy = splitBy;
        this.filterBy = filterBy;
        this.buildInQuery = buildInQuery;
        this.threshold = threshold;
        this.relationToThreshold = relationToThreshold;
        this.filterQuery = filterQuery;
        this.subaggregations = subaggregations;
        this.forecastFrom = forecastFrom;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean isRunOnce() {
        return this.runOnce;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getForecasterId() {
        return this.forecasterId;
    }

    public List<String> getSplitBy() {
        return this.splitBy;
    }

    public FilterBy getFilterBy() {
        return this.filterBy;
    }

    public BuildInQuery getBuildInQuery() {
        return this.buildInQuery;
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public QueryBuilder getFilterQuery() {
        return this.filterQuery;
    }

    public List<Subaggregation> getSubaggregations() {
        return this.subaggregations;
    }

    public Instant getForecastFrom() {
        return this.forecastFrom;
    }

    public RelationalOperation getRelationToThreshold() {
        return this.relationToThreshold;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setForecasterId(String forecasterId) {
        this.forecasterId = forecasterId;
    }

    public void setRunOnce(boolean runOnce) {
        this.runOnce = runOnce;
    }

    public void setSplitBy(List<String> splitBy) {
        this.splitBy = splitBy;
    }

    public void setFilterBy(FilterBy filterBy) {
        this.filterBy = filterBy;
    }

    public void setBuildInQuery(BuildInQuery buildInQuery) {
        this.buildInQuery = buildInQuery;
    }

    public void setThreshold(Float threshold) {
        this.threshold = threshold;
    }

    public void setFilterQuery(QueryBuilder filterQuery) {
        this.filterQuery = filterQuery;
    }

    public void setSubaggregations(List<Subaggregation> subaggregations) {
        this.subaggregations = subaggregations;
    }

    public void setForecastFrom(Instant forecastFrom) {
        this.forecastFrom = forecastFrom;
    }

    public void setRelationToThreshold(RelationalOperation relationToThreshold) {
        this.relationToThreshold = relationToThreshold;
    }

    public static SearchTopForecastResultRequest parse(XContentParser parser, String forecasterId) throws IOException {
        String taskId = null;
        Integer size = null;
        List<String> splitBy = null;
        FilterBy filterBy = null;
        BuildInQuery buildInQuery = null;
        Float threshold = null;
        RelationalOperation relationToThreshold = null;
        QueryBuilder filterQuery = null;
        ArrayList<Subaggregation> subaggregations = new ArrayList<Subaggregation>();
        Instant forecastFrom = null;
        boolean runOnce = false;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block31: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "task_id": {
                    taskId = parser.text();
                    break;
                }
                case "size": {
                    size = parser.intValue();
                    break;
                }
                case "split_by": {
                    splitBy = Arrays.asList(parser.text().split(","));
                    break;
                }
                case "filter_by": {
                    filterBy = FilterBy.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "build_in_query": {
                    buildInQuery = BuildInQuery.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "threshold": {
                    threshold = Float.valueOf(parser.floatValue());
                    break;
                }
                case "relation_to_threshold": {
                    relationToThreshold = RelationalOperation.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "filter_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    try {
                        filterQuery = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                        break;
                    }
                    catch (ParsingException | XContentParseException e) {
                        throw new ValidationException("Custom query error in data filter: " + e.getMessage(), ValidationIssueType.FILTER_QUERY, ValidationAspect.FORECASTER);
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().contains("empty clause")) continue block31;
                        throw e;
                    }
                }
                case "subaggregations": {
                    try {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            subaggregations.add(Subaggregation.parse(parser));
                        }
                        continue block31;
                    }
                    catch (Exception e) {
                        if (e instanceof ParsingException || e instanceof XContentParseException) {
                            throw new ValidationException("Custom query error: " + e.getMessage(), ValidationIssueType.SUBAGGREGATION, ValidationAspect.FORECASTER);
                        }
                        throw e;
                    }
                }
                case "forecast_from": {
                    forecastFrom = ParseUtils.toInstant(parser);
                    break;
                }
                case "run_once": {
                    runOnce = parser.booleanValue();
                    break;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        return new SearchTopForecastResultRequest(forecasterId, taskId, runOnce, size, splitBy, filterBy, buildInQuery, threshold, relationToThreshold, filterQuery, subaggregations, forecastFrom);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TASK_ID_FIELD, this.taskId).field(SPLIT_BY_FIELD, String.join((CharSequence)",", this.splitBy)).field(FILTER_BY_FIELD, this.filterBy.name()).field(RUN_ONCE_FIELD, this.runOnce);
        if (this.size != null) {
            builder.field(SIZE_FIELD, this.size);
        }
        if (this.buildInQuery != null) {
            builder.field(BUILD_IN_QUERY_FIELD, (Object)this.buildInQuery);
        }
        if (this.threshold != null) {
            builder.field(THRESHOLD_FIELD, this.threshold);
        }
        if (this.relationToThreshold != null) {
            builder.field(RELATION_TO_THRESHOLD_FIELD, (Object)this.relationToThreshold);
        }
        if (this.filterQuery != null) {
            builder.field(FILTER_QUERY_FIELD, (ToXContent)this.filterQuery);
        }
        if (this.subaggregations != null) {
            builder.field(SUBAGGREGATIONS_FIELD, (Object)this.subaggregations.toArray());
        }
        if (this.forecastFrom != null) {
            builder.field(FORECAST_FROM_FIELD, this.forecastFrom.toString());
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.forecasterId);
        out.writeOptionalString(this.taskId);
        out.writeBoolean(this.runOnce);
        out.writeOptionalInt(this.size);
        out.writeOptionalStringCollection(this.splitBy);
        if (this.filterBy == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.filterBy);
        }
        if (this.buildInQuery == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.buildInQuery);
        }
        out.writeOptionalFloat(this.threshold);
        if (this.relationToThreshold == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.relationToThreshold);
        }
        if (this.filterQuery == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeNamedWriteable((NamedWriteable)this.filterQuery);
        }
        if (this.subaggregations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeList(this.subaggregations);
        }
        out.writeOptionalInstant(this.forecastFrom);
    }

    public ActionRequestValidationException validate() {
        if (this.forecasterId == null) {
            return ValidateActions.addValidationError((String)"Cannot find forecasterId", null);
        }
        if (this.filterBy == null) {
            return ValidateActions.addValidationError((String)"Must set filter_by", null);
        }
        if (this.forecastFrom == null) {
            return ValidateActions.addValidationError((String)"Must set forecast_from with epoch of milliseconds", null);
        }
        if (this.filterBy == FilterBy.BUILD_IN_QUERY != (this.buildInQuery != null)) {
            throw new IllegalArgumentException("If 'filter_by' is set to BUILD_IN_QUERY, a 'build_in_query' type must be provided. Otherwise, 'build_in_query' should not be given.");
        }
        if (this.filterBy == FilterBy.BUILD_IN_QUERY && this.buildInQuery == BuildInQuery.DISTANCE_TO_THRESHOLD_VALUE && (this.threshold == null || this.relationToThreshold == null)) {
            return ValidateActions.addValidationError((String)String.format(Locale.ROOT, "Must set threshold and relation_to_threshold, but get %s and %s", new Object[]{this.threshold, this.relationToThreshold}), null);
        }
        if (this.filterBy == FilterBy.CUSTOM_QUERY && (this.subaggregations == null || this.subaggregations.isEmpty())) {
            return ValidateActions.addValidationError((String)"Must set subaggregations", null);
        }
        if (!this.runOnce && !Strings.isNullOrEmpty((String)this.taskId)) {
            return ValidateActions.addValidationError((String)"task id must not be set when run_once is false", null);
        }
        return null;
    }
}

