/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar;

import com.oracle.labs.mlrg.olcut.config.Config;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.columnar.RowProcessor;

public abstract class ColumnarDataSource<T extends Output<T>>
implements ConfigurableDataSource<T> {
    @Config(mandatory=true, description="The output factory to use.")
    private OutputFactory<T> outputFactory;
    @Config(mandatory=true, description="The row processor to use.")
    protected RowProcessor<T> rowProcessor;
    @Config(description="Is an output required from each row?")
    protected boolean outputRequired = true;

    protected ColumnarDataSource() {
    }

    protected ColumnarDataSource(OutputFactory<T> outputFactory, RowProcessor<T> rowProcessor, boolean outputRequired) {
        this.outputFactory = outputFactory;
        this.rowProcessor = rowProcessor;
        this.outputRequired = outputRequired;
    }

    public Map<String, Class<?>> getMetadataTypes() {
        return this.rowProcessor.getMetadataTypes();
    }

    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    public Iterator<Example<T>> iterator() {
        return new InnerIterator<T>(this.rowProcessor, this.rowIterator(), this.outputRequired);
    }

    protected abstract ColumnarIterator rowIterator();

    private static class InnerIterator<T extends Output<T>>
    implements Iterator<Example<T>> {
        private final boolean outputRequired;
        private final ColumnarIterator iterator;
        private final RowProcessor<T> processor;
        private Example<T> buffer = null;

        InnerIterator(RowProcessor<T> processor, ColumnarIterator iterator, boolean outputRequired) {
            this.processor = processor.copy();
            if (!this.processor.isConfigured()) {
                this.processor.expandRegexMapping(iterator.getFields());
            }
            this.iterator = iterator;
            this.outputRequired = outputRequired;
        }

        @Override
        public boolean hasNext() {
            if (this.buffer != null) {
                return true;
            }
            while (this.buffer == null && this.iterator.hasNext()) {
                ColumnarIterator.Row m = this.iterator.next();
                Optional<Example<T>> exampleOpt = this.processor.generateExample(m, this.outputRequired);
                if (!exampleOpt.isPresent()) continue;
                this.buffer = exampleOpt.get();
            }
            return this.buffer != null;
        }

        @Override
        public Example<T> next() {
            if (this.hasNext()) {
                Example<T> ret = this.buffer;
                this.buffer = null;
                return ret;
            }
            throw new NoSuchElementException("No more data");
        }
    }
}

