/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.OpenSearchAbortPolicy;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.threadpool.CancellableAdapter;
import org.opensearch.threadpool.ScheduledCancellableAdapter;

public interface Scheduler {
    public static ScheduledThreadPoolExecutor initScheduler(Settings settings) {
        SafeScheduledThreadPoolExecutor scheduler = new SafeScheduledThreadPoolExecutor(1, OpenSearchExecutors.daemonThreadFactory(settings, "scheduler"), new OpenSearchAbortPolicy());
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    public static boolean terminate(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        scheduledThreadPoolExecutor.shutdown();
        if (Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit)) {
            return true;
        }
        scheduledThreadPoolExecutor.shutdownNow();
        return Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit);
    }

    public static boolean awaitTermination(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        try {
            if (scheduledThreadPoolExecutor.awaitTermination(timeout, timeUnit)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public ScheduledCancellable schedule(Runnable var1, TimeValue var2, String var3);

    default public Cancellable scheduleWithFixedDelay(Runnable command, TimeValue interval, String executor) {
        return new ReschedulingRunnable(command, interval, executor, this, e -> {}, e -> {});
    }

    public static Cancellable wrapAsCancellable(Future<?> future) {
        return new CancellableAdapter(future);
    }

    public static ScheduledCancellable wrapAsScheduledCancellable(ScheduledFuture<?> scheduledFuture) {
        return new ScheduledCancellableAdapter(scheduledFuture);
    }

    public static class SafeScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }

        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            RunnableFuture runnableFuture;
            if (t != null) {
                return;
            }
            if (r instanceof RunnableFuture && (runnableFuture = (RunnableFuture)r).isDone()) {
                ExceptionsHelper.reThrowIfNotNull((Throwable)OpenSearchExecutors.rethrowErrors(r));
            }
        }
    }

    public static final class ReschedulingRunnable
    extends AbstractRunnable
    implements Cancellable {
        private final Runnable runnable;
        private final TimeValue interval;
        private final String executor;
        private final Scheduler scheduler;
        private final Consumer<Exception> rejectionConsumer;
        private final Consumer<Exception> failureConsumer;
        private volatile boolean run = true;

        ReschedulingRunnable(Runnable runnable, TimeValue interval, String executor, Scheduler scheduler, Consumer<Exception> rejectionConsumer, Consumer<Exception> failureConsumer) {
            this.runnable = runnable;
            this.interval = interval;
            this.executor = executor;
            this.scheduler = scheduler;
            this.rejectionConsumer = rejectionConsumer;
            this.failureConsumer = failureConsumer;
            scheduler.schedule(this, interval, executor);
        }

        @Override
        public boolean cancel() {
            boolean result = this.run;
            this.run = false;
            return result;
        }

        @Override
        public boolean isCancelled() {
            return !this.run;
        }

        @Override
        public void doRun() {
            if (this.run) {
                this.runnable.run();
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.failureConsumer.accept(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.run = false;
            this.rejectionConsumer.accept(e);
        }

        @Override
        public void onAfter() {
            if (this.run) {
                try {
                    this.scheduler.schedule(this, this.interval, this.executor);
                }
                catch (OpenSearchRejectedExecutionException e) {
                    this.onRejection((Exception)((Object)e));
                }
            }
        }

        public String toString() {
            return "ReschedulingRunnable{runnable=" + String.valueOf(this.runnable) + ", interval=" + String.valueOf(this.interval) + "}";
        }
    }

    @PublicApi(since="1.0.0")
    public static interface ScheduledCancellable
    extends Delayed,
    Cancellable {
    }

    @PublicApi(since="1.0.0")
    public static interface Cancellable {
        public boolean cancel();

        public boolean isCancelled();
    }
}

