/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocIdStreamHelper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector.SimpleRangeCollector;

public class SubAggRangeCollector
extends SimpleRangeCollector {
    private static final Logger logger = LogManager.getLogger(SubAggRangeCollector.class);
    private final Function<Integer, Long> getBucketOrd;
    private final BucketCollector collectableSubAggregators;
    private final LeafReaderContext leafCtx;
    private final Bits liveDocs;
    private final FixedBitSet bitSet;

    public SubAggRangeCollector(Ranges ranges, BiConsumer<Integer, Integer> incrementRangeDocCount, int maxNumNonZeroRange, int activeIndex, FilterRewriteOptimizationContext.OptimizeResult result, Function<Integer, Long> getBucketOrd, FilterRewriteOptimizationContext.SubAggCollectorParam subAggCollectorParam) {
        super(ranges, incrementRangeDocCount, maxNumNonZeroRange, activeIndex, result);
        this.getBucketOrd = getBucketOrd;
        this.collectableSubAggregators = subAggCollectorParam.collectableSubAggregators();
        this.leafCtx = subAggCollectorParam.leafCtx();
        this.liveDocs = this.leafCtx.reader().getLiveDocs();
        this.bitSet = new FixedBitSet(this.leafCtx.reader().maxDoc());
    }

    @Override
    public boolean hasSubAgg() {
        return true;
    }

    private boolean isDocLive(int docId) {
        return this.liveDocs == null || this.liveDocs.get(docId);
    }

    @Override
    public void countNode(int count) {
        throw new UnsupportedOperationException("countNode should be unreachable");
    }

    @Override
    public void count() {
        throw new UnsupportedOperationException("countNode should be unreachable");
    }

    @Override
    public void collectDocId(int docId) {
        if (this.isDocLive(docId)) {
            ++this.counter;
            this.bitSet.set(docId);
        }
    }

    @Override
    public void collectDocIdSet(DocIdSetIterator iter) throws IOException {
        iter.nextDoc();
        int doc = iter.docID();
        while (doc < Integer.MAX_VALUE) {
            if (this.isDocLive(doc)) {
                ++this.counter;
                this.bitSet.set(doc);
            }
            doc = iter.nextDoc();
        }
    }

    @Override
    public void finalizePreviousRange() {
        super.finalizePreviousRange();
        long bucketOrd = this.getBucketOrd.apply(this.activeIndex);
        logger.trace("finalize range {} with bucket ordinal {}", (Object)this.activeIndex, (Object)bucketOrd);
        try {
            LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(this.leafCtx);
            sub.collect(DocIdStreamHelper.getDocIdStream(this.bitSet), bucketOrd);
            logger.trace("collected sub aggregation for bucket {}", (Object)bucketOrd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.bitSet.clear();
    }
}

