/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class DoubleValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public DoubleValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
        return ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
    }

    private NumericDoubleValues getNumericDocValues(LeafReaderContext context, double missingValue) throws IOException {
        SortedNumericDoubleValues values = this.getValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    protected void setScorer(Scorable scorer, LeafReaderContext context) {
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final double dMissingValue = (Double)this.missingObject(this.missingValue, reversed);
        return new DoubleComparator(this, numHits, fieldname, dMissingValue, reversed, this.filterPruning(pruning)){
            final /* synthetic */ DoubleValuesComparatorSource this$0;
            {
                this.this$0 = this$0;
                super(numHits, field, missingValue, reverse, pruning);
            }

            public LeafFieldComparator getLeafComparator(final LeafReaderContext context) throws IOException {
                return new DoubleComparator.DoubleLeafComparator(this, context){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super((DoubleComparator)this$1, context2);
                    }

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                        return this.this$1.this$0.getNumericDocValues(context2, dMissingValue).getRawDoubleValues();
                    }

                    public void setScorer(Scorable scorer) {
                        this.this$1.this$0.setScorer(scorer, context);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForDoubles(this, bigArrays, sortOrder, format, bucketSize, extra){
            private final double dMissingValue;
            final /* synthetic */ DoubleValuesComparatorSource this$0;
            {
                this.this$0 = this$0;
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.dMissingValue = (Double)this.this$0.missingObject(this.this$0.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForDoubles.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForDoubles.Leaf(this, ctx){
                    private final NumericDoubleValues docValues;
                    private double docValue;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(this$1, ctx2);
                        this.docValues = this.this$1.this$0.getNumericDocValues(ctx, this.this$1.dMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.doubleValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected double docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

