/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.remote;

import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.common.remote.RemoteWriteableEntity;
import org.opensearch.core.compress.Compressor;

public abstract class RemoteWriteableBlobEntity<T>
implements RemoteWriteableEntity<T> {
    protected String blobFileName;
    protected String blobName;
    private final String clusterUUID;
    private final Compressor compressor;
    private String[] pathTokens;

    public RemoteWriteableBlobEntity(String clusterUUID, Compressor compressor) {
        this.clusterUUID = clusterUUID;
        this.compressor = compressor;
    }

    public abstract BlobPathParameters getBlobPathParameters();

    public abstract String getType();

    public String getFullBlobName() {
        return this.blobName;
    }

    public String getBlobFileName() {
        if (this.blobFileName == null) {
            String[] pathTokens = this.getBlobPathTokens();
            if (pathTokens == null || pathTokens.length < 1) {
                return null;
            }
            this.blobFileName = pathTokens[pathTokens.length - 1];
        }
        return this.blobFileName;
    }

    public String[] getBlobPathTokens() {
        if (this.pathTokens != null) {
            return this.pathTokens;
        }
        if (this.blobName == null) {
            return null;
        }
        this.pathTokens = this.blobName.split("/");
        return this.pathTokens;
    }

    public abstract String generateBlobFileName();

    public BlobPath getPrefixedPath(BlobPath blobPath) {
        return blobPath;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public void setFullBlobName(BlobPath blobPath) {
        this.blobName = blobPath.buildAsString() + this.blobFileName;
    }

    protected Compressor getCompressor() {
        return this.compressor;
    }
}

