/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.StepListener;
import org.opensearch.action.search.DeletePitInfo;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.action.search.GetAllPitNodesRequest;
import org.opensearch.action.search.GetAllPitNodesResponse;
import org.opensearch.action.search.PitSearchContextIdForNode;
import org.opensearch.action.search.SearchContextId;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.search.SearchUtils;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

public class PitService {
    private static final Logger logger = LogManager.getLogger(PitService.class);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final TransportService transportService;
    private final NodeClient nodeClient;

    @Inject
    public PitService(ClusterService clusterService, SearchTransportService searchTransportService, TransportService transportService, NodeClient nodeClient) {
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.transportService = transportService;
        this.nodeClient = nodeClient;
    }

    public void deletePitContexts(Map<String, List<PitSearchContextIdForNode>> nodeToContextsMap, ActionListener<DeletePitResponse> listener) {
        if (nodeToContextsMap.size() == 0) {
            listener.onResponse((Object)new DeletePitResponse(Collections.emptyList()));
            return;
        }
        Set<String> clusters = nodeToContextsMap.values().stream().flatMap(Collection::stream).filter(ctx -> !Strings.isEmpty((CharSequence)ctx.getSearchContextIdForNode().getClusterAlias())).map(c -> c.getSearchContextIdForNode().getClusterAlias()).collect(Collectors.toSet());
        StepListener lookupListener = (StepListener)SearchUtils.getConnectionLookupListener(this.searchTransportService.getRemoteClusterService(), this.clusterService.state(), clusters);
        lookupListener.whenComplete(nodeLookup -> {
            GroupedActionListener<DeletePitResponse> groupedListener = this.getDeletePitGroupedListener(listener, nodeToContextsMap.size());
            for (Map.Entry entry : nodeToContextsMap.entrySet()) {
                String clusterAlias = ((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getClusterAlias();
                DiscoveryNode node = (DiscoveryNode)nodeLookup.apply(clusterAlias, ((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode());
                if (node == null) {
                    node = this.clusterService.state().getNodes().get(((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode());
                }
                if (node == null) {
                    logger.error(() -> new ParameterizedMessage("node [{}] not found", (Object)((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode()));
                    ArrayList<DeletePitInfo> deletePitInfos = new ArrayList<DeletePitInfo>();
                    for (PitSearchContextIdForNode pitSearchContextIdForNode : (List)entry.getValue()) {
                        deletePitInfos.add(new DeletePitInfo(false, pitSearchContextIdForNode.getPitId()));
                    }
                    groupedListener.onResponse(new DeletePitResponse(deletePitInfos));
                    continue;
                }
                try {
                    Transport.Connection connection = this.searchTransportService.getConnection(clusterAlias, node);
                    this.searchTransportService.sendFreePITContexts(connection, (List)entry.getValue(), groupedListener);
                }
                catch (Exception e) {
                    String nodeName = node.getName();
                    logger.error(() -> new ParameterizedMessage("Delete PITs failed on node [{}]", (Object)nodeName), (Throwable)e);
                    ArrayList<DeletePitInfo> deletePitInfos = new ArrayList<DeletePitInfo>();
                    for (PitSearchContextIdForNode pitSearchContextIdForNode : (List)entry.getValue()) {
                        deletePitInfos.add(new DeletePitInfo(false, pitSearchContextIdForNode.getPitId()));
                    }
                    groupedListener.onResponse(new DeletePitResponse(deletePitInfos));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public GroupedActionListener<DeletePitResponse> getDeletePitGroupedListener(final ActionListener<DeletePitResponse> listener, int size) {
        return new GroupedActionListener<DeletePitResponse>(new ActionListener<Collection<DeletePitResponse>>(this){

            public void onResponse(Collection<DeletePitResponse> responses) {
                HashMap<String, Boolean> pitIdToSucceededMap = new HashMap<String, Boolean>();
                for (DeletePitResponse deletePitResponse : responses) {
                    for (DeletePitInfo deletePitInfo : deletePitResponse.getDeletePitResults()) {
                        if (!pitIdToSucceededMap.containsKey(deletePitInfo.getPitId())) {
                            pitIdToSucceededMap.put(deletePitInfo.getPitId(), deletePitInfo.isSuccessful());
                        }
                        if (deletePitInfo.isSuccessful()) continue;
                        logger.debug(() -> new ParameterizedMessage("Deleting PIT with ID {} failed ", (Object)deletePitInfo.getPitId()));
                        pitIdToSucceededMap.put(deletePitInfo.getPitId(), deletePitInfo.isSuccessful());
                    }
                }
                ArrayList<DeletePitInfo> deletePitResults = new ArrayList<DeletePitInfo>();
                for (Map.Entry entry : pitIdToSucceededMap.entrySet()) {
                    deletePitResults.add(new DeletePitInfo((Boolean)entry.getValue(), (String)entry.getKey()));
                }
                DeletePitResponse deletePitResponse = new DeletePitResponse(deletePitResults);
                listener.onResponse((Object)deletePitResponse);
            }

            public void onFailure(Exception e) {
                logger.error("Delete PITs failed", (Throwable)e);
                listener.onFailure(e);
            }
        }, size);
    }

    public Map<String, String[]> getIndicesForPits(List<String> pitIds) {
        HashMap<String, String[]> pitToIndicesMap = new HashMap<String, String[]>();
        for (String pitId : pitIds) {
            pitToIndicesMap.put(pitId, SearchContextId.decode(this.nodeClient.getNamedWriteableRegistry(), pitId).getActualIndices());
        }
        return pitToIndicesMap;
    }

    public Set<String> getIndicesForPitsFlat(Collection<String> pitIds) {
        HashSet<String> result = new HashSet<String>();
        for (String pitId : pitIds) {
            result.addAll(Arrays.asList(SearchContextId.decode(this.nodeClient.getNamedWriteableRegistry(), pitId).getActualIndices()));
        }
        return result;
    }

    public void getAllPits(final ActionListener<GetAllPitNodesResponse> getAllPitsListener) {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : this.clusterService.state().nodes().getDataNodes().values()) {
            nodes.add(node);
        }
        DiscoveryNode[] disNodesArr = nodes.toArray(new DiscoveryNode[0]);
        GetAllPitNodesRequest getAllPitNodesRequest = new GetAllPitNodesRequest(disNodesArr);
        this.transportService.sendRequest(this.transportService.getLocalNode(), "indices:data/read/point_in_time/readall", getAllPitNodesRequest, new TransportResponseHandler<GetAllPitNodesResponse>(){

            @Override
            public void handleResponse(GetAllPitNodesResponse response) {
                getAllPitsListener.onResponse((Object)response);
            }

            @Override
            public void handleException(TransportException exp) {
                getAllPitsListener.onFailure((Exception)((Object)exp));
            }

            @Override
            public String executor() {
                return "same";
            }

            public GetAllPitNodesResponse read(StreamInput in) throws IOException {
                return new GetAllPitNodesResponse(in);
            }
        });
    }
}

