/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query.functionscore;

import org.opensearch.common.lucene.search.function.FieldValueFactorFunction;
import org.opensearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.protobufs.FieldValueFactorModifier;
import org.opensearch.protobufs.FieldValueFactorScoreFunction;

class FieldValueFactorFunctionProtoUtils {
    private FieldValueFactorFunctionProtoUtils() {
    }

    static ScoreFunctionBuilder<?> fromProto(FieldValueFactorScoreFunction fieldValueFactor) {
        if (fieldValueFactor == null) {
            throw new IllegalArgumentException("FieldValueFactorScoreFunction cannot be null");
        }
        FieldValueFactorFunctionBuilder builder = new FieldValueFactorFunctionBuilder(fieldValueFactor.getField());
        if (fieldValueFactor.hasFactor()) {
            builder.factor(fieldValueFactor.getFactor());
        }
        if (fieldValueFactor.hasMissing()) {
            builder.missing(fieldValueFactor.getMissing());
        }
        if (fieldValueFactor.getModifier() != FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_NONE) {
            builder.modifier(FieldValueFactorFunctionProtoUtils.parseFieldValueFactorModifier(fieldValueFactor.getModifier()));
        }
        return builder;
    }

    private static FieldValueFactorFunction.Modifier parseFieldValueFactorModifier(FieldValueFactorModifier modifier) {
        return switch (modifier) {
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_NONE -> FieldValueFactorFunction.Modifier.NONE;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_LOG -> FieldValueFactorFunction.Modifier.LOG;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_LOG1P -> FieldValueFactorFunction.Modifier.LOG1P;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_LOG2P -> FieldValueFactorFunction.Modifier.LOG2P;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_LN -> FieldValueFactorFunction.Modifier.LN;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_LN1P -> FieldValueFactorFunction.Modifier.LN1P;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_LN2P -> FieldValueFactorFunction.Modifier.LN2P;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_SQUARE -> FieldValueFactorFunction.Modifier.SQUARE;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_SQRT -> FieldValueFactorFunction.Modifier.SQRT;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_RECIPROCAL -> FieldValueFactorFunction.Modifier.RECIPROCAL;
            case FieldValueFactorModifier.FIELD_VALUE_FACTOR_MODIFIER_UNSPECIFIED -> FieldValueFactorFunction.Modifier.NONE;
            default -> throw new IllegalArgumentException("Unknown FieldValueFactorModifier: " + String.valueOf(modifier));
        };
    }
}

