/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.ReindexRethrottleResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class ReindexRethrottleRequest
extends RequestBase
implements ToCopyableBuilder<Builder, ReindexRethrottleRequest> {
    @Nullable
    private final Float requestsPerSecond;
    @Nonnull
    private final String taskId;
    public static final Endpoint<ReindexRethrottleRequest, ReindexRethrottleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ReindexRethrottleRequest, ReindexRethrottleResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_reindex/");
        SimpleEndpoint.pathEncode(request.taskId, buf);
        buf.append("/_rethrottle");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, ReindexRethrottleResponse._DESERIALIZER);

    private ReindexRethrottleRequest(Builder builder) {
        super(builder);
        this.requestsPerSecond = builder.requestsPerSecond;
        this.taskId = ApiTypeHelper.requireNonNull(builder.taskId, this, "taskId");
    }

    public static ReindexRethrottleRequest of(Function<Builder, ObjectBuilder<ReindexRethrottleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nonnull
    public final String taskId() {
        return this.taskId;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(this.requestsPerSecond));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.requestsPerSecond);
        result = 31 * result + this.taskId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReindexRethrottleRequest other = (ReindexRethrottleRequest)o;
        return Objects.equals(this.requestsPerSecond, other.requestsPerSecond) && this.taskId.equals(other.taskId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ReindexRethrottleRequest> {
        @Nullable
        private Float requestsPerSecond;
        private String taskId;

        public Builder() {
        }

        private Builder(ReindexRethrottleRequest o) {
            super(o);
            this.requestsPerSecond = o.requestsPerSecond;
            this.taskId = o.taskId;
        }

        private Builder(Builder o) {
            super(o);
            this.requestsPerSecond = o.requestsPerSecond;
            this.taskId = o.taskId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder requestsPerSecond(@Nullable Float value) {
            this.requestsPerSecond = value;
            return this;
        }

        @Nonnull
        public final Builder taskId(String value) {
            this.taskId = value;
            return this;
        }

        @Override
        @Nonnull
        public ReindexRethrottleRequest build() {
            this._checkSingleUse();
            return new ReindexRethrottleRequest(this);
        }
    }
}

