/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.allocation_explain.NodeDiskUsage;
import org.opensearch.client.opensearch.cluster.allocation_explain.ReservedSize;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterInfo
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterInfo> {
    @Nonnull
    private final Map<String, NodeDiskUsage> nodes;
    @Nonnull
    private final List<ReservedSize> reservedSizes;
    @Nonnull
    private final Map<String, String> shardDataSetSizes;
    @Nonnull
    private final Map<String, String> shardPaths;
    @Nonnull
    private final Map<String, JsonData> shardSizes;
    public static final JsonpDeserializer<ClusterInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterInfo::setupClusterInfoDeserializer);

    private ClusterInfo(Builder builder) {
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
        this.reservedSizes = ApiTypeHelper.unmodifiableRequired(builder.reservedSizes, (Object)this, "reservedSizes");
        this.shardDataSetSizes = ApiTypeHelper.unmodifiable(builder.shardDataSetSizes);
        this.shardPaths = ApiTypeHelper.unmodifiableRequired(builder.shardPaths, (Object)this, "shardPaths");
        this.shardSizes = ApiTypeHelper.unmodifiableRequired(builder.shardSizes, (Object)this, "shardSizes");
    }

    public static ClusterInfo of(Function<Builder, ObjectBuilder<ClusterInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, NodeDiskUsage> nodes() {
        return this.nodes;
    }

    @Nonnull
    public final List<ReservedSize> reservedSizes() {
        return this.reservedSizes;
    }

    @Nonnull
    public final Map<String, String> shardDataSetSizes() {
        return this.shardDataSetSizes;
    }

    @Nonnull
    public final Map<String, String> shardPaths() {
        return this.shardPaths;
    }

    @Nonnull
    public final Map<String, JsonData> shardSizes() {
        return this.shardSizes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, NodeDiskUsage> entry : this.nodes.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("reserved_sizes");
        generator.writeStartArray();
        for (ReservedSize reservedSize : this.reservedSizes) {
            reservedSize.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (ApiTypeHelper.isDefined(this.shardDataSetSizes)) {
            generator.writeKey("shard_data_set_sizes");
            generator.writeStartObject();
            for (Map.Entry entry : this.shardDataSetSizes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("shard_paths");
        generator.writeStartObject();
        for (Map.Entry entry : this.shardPaths.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.write((String)entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("shard_sizes");
        generator.writeStartObject();
        for (Map.Entry entry : this.shardSizes.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeDiskUsage._DESERIALIZER), "nodes");
        op.add(Builder::reservedSizes, JsonpDeserializer.arrayDeserializer(ReservedSize._DESERIALIZER), "reserved_sizes");
        op.add(Builder::shardDataSetSizes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "shard_data_set_sizes");
        op.add(Builder::shardPaths, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "shard_paths");
        op.add(Builder::shardSizes, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "shard_sizes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.reservedSizes.hashCode();
        result = 31 * result + Objects.hashCode(this.shardDataSetSizes);
        result = 31 * result + this.shardPaths.hashCode();
        result = 31 * result + this.shardSizes.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)o;
        return this.nodes.equals(other.nodes) && this.reservedSizes.equals(other.reservedSizes) && Objects.equals(this.shardDataSetSizes, other.shardDataSetSizes) && this.shardPaths.equals(other.shardPaths) && this.shardSizes.equals(other.shardSizes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterInfo> {
        private Map<String, NodeDiskUsage> nodes;
        private List<ReservedSize> reservedSizes;
        @Nullable
        private Map<String, String> shardDataSetSizes;
        private Map<String, String> shardPaths;
        private Map<String, JsonData> shardSizes;

        public Builder() {
        }

        private Builder(ClusterInfo o) {
            this.nodes = Builder._mapCopy(o.nodes);
            this.reservedSizes = Builder._listCopy(o.reservedSizes);
            this.shardDataSetSizes = Builder._mapCopy(o.shardDataSetSizes);
            this.shardPaths = Builder._mapCopy(o.shardPaths);
            this.shardSizes = Builder._mapCopy(o.shardSizes);
        }

        private Builder(Builder o) {
            this.nodes = Builder._mapCopy(o.nodes);
            this.reservedSizes = Builder._listCopy(o.reservedSizes);
            this.shardDataSetSizes = Builder._mapCopy(o.shardDataSetSizes);
            this.shardPaths = Builder._mapCopy(o.shardPaths);
            this.shardSizes = Builder._mapCopy(o.shardSizes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder nodes(Map<String, NodeDiskUsage> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, NodeDiskUsage value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<NodeDiskUsage.Builder, ObjectBuilder<NodeDiskUsage>> fn) {
            return this.nodes(key, fn.apply(new NodeDiskUsage.Builder()).build());
        }

        @Nonnull
        public final Builder reservedSizes(List<ReservedSize> list) {
            this.reservedSizes = Builder._listAddAll(this.reservedSizes, list);
            return this;
        }

        @Nonnull
        public final Builder reservedSizes(ReservedSize value, ReservedSize ... values) {
            this.reservedSizes = Builder._listAdd(this.reservedSizes, value, values);
            return this;
        }

        @Nonnull
        public final Builder reservedSizes(Function<ReservedSize.Builder, ObjectBuilder<ReservedSize>> fn) {
            return this.reservedSizes(fn.apply(new ReservedSize.Builder()).build(), new ReservedSize[0]);
        }

        @Nonnull
        public final Builder shardDataSetSizes(Map<String, String> map) {
            this.shardDataSetSizes = Builder._mapPutAll(this.shardDataSetSizes, map);
            return this;
        }

        @Nonnull
        public final Builder shardDataSetSizes(String key, String value) {
            this.shardDataSetSizes = Builder._mapPut(this.shardDataSetSizes, key, value);
            return this;
        }

        @Nonnull
        public final Builder shardPaths(Map<String, String> map) {
            this.shardPaths = Builder._mapPutAll(this.shardPaths, map);
            return this;
        }

        @Nonnull
        public final Builder shardPaths(String key, String value) {
            this.shardPaths = Builder._mapPut(this.shardPaths, key, value);
            return this;
        }

        @Nonnull
        public final Builder shardSizes(Map<String, JsonData> map) {
            this.shardSizes = Builder._mapPutAll(this.shardSizes, map);
            return this;
        }

        @Nonnull
        public final Builder shardSizes(String key, JsonData value) {
            this.shardSizes = Builder._mapPut(this.shardSizes, key, value);
            return this;
        }

        @Override
        @Nonnull
        public ClusterInfo build() {
            this._checkSingleUse();
            return new ClusterInfo(this);
        }
    }
}

