/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public abstract class BucketAggregationBase
extends AggregationBase {
    @Nonnull
    private final Map<String, Aggregation> aggregations;
    @Nonnull
    private final Map<String, Aggregation> aggs;

    protected BucketAggregationBase(AbstractBuilder<?> builder) {
        super(builder);
        this.aggregations = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).aggregations);
        this.aggs = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).aggs);
    }

    @Nonnull
    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nonnull
    public final Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> item0 : this.aggregations.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.aggs)) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> item0 : this.aggs.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBucketAggregationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        BucketAggregationBase.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations");
        op.add(AbstractBuilder::aggs, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggs");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.aggregations);
        result = 31 * result + Objects.hashCode(this.aggs);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketAggregationBase other = (BucketAggregationBase)o;
        return Objects.equals(this.aggregations, other.aggregations) && Objects.equals(this.aggs, other.aggs);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Map<String, Aggregation> aggs;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(BucketAggregationBase o) {
            super(o);
            this.aggregations = AbstractBuilder._mapCopy(o.aggregations);
            this.aggs = AbstractBuilder._mapCopy(o.aggs);
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.aggregations = AbstractBuilder._mapCopy(o.aggregations);
            this.aggs = AbstractBuilder._mapCopy(o.aggs);
        }

        @Nonnull
        public final BuilderT aggregations(Map<String, Aggregation> map) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT aggregations(String key, Aggregation value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        @Nonnull
        public final BuilderT aggs(Map<String, Aggregation> map) {
            this.aggs = AbstractBuilder._mapPutAll(this.aggs, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT aggs(String key, Aggregation value) {
            this.aggs = AbstractBuilder._mapPut(this.aggs, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT aggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(key, fn.apply(new Aggregation.Builder()).build());
        }
    }
}

