/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SymmetricSecretKey
implements SymmetricKey,
Destroyable {
    private final boolean approvedModeOnly;
    private int hashCode;
    private Algorithm algorithm;
    private byte[] bytes;
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);

    public SymmetricSecretKey(Algorithm algorithm, byte[] byArray) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = algorithm;
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    public SymmetricSecretKey(Parameters parameters, byte[] byArray) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = parameters.getAlgorithm();
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    @Override
    public Algorithm getAlgorithm() {
        this.checkDestroyed();
        return this.algorithm;
    }

    private void zeroize() {
        for (int i = 0; i != this.bytes.length; ++i) {
            this.bytes[i] = 0;
        }
        this.bytes = null;
        this.algorithm = null;
        this.hashCode = 0;
    }

    @Override
    public byte[] getKeyBytes() {
        this.checkApprovedOnlyModeStatus();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.CanOutputSecretKey);
        }
        byte[] byArray = Arrays.clone(this.bytes);
        this.checkDestroyed();
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof SymmetricSecretKey)) {
            return false;
        }
        SymmetricSecretKey symmetricSecretKey = (SymmetricSecretKey)object;
        symmetricSecretKey.checkApprovedOnlyModeStatus();
        return this.algorithm != null && this.algorithm.equals(symmetricSecretKey.algorithm) && Arrays.constantTimeAreEqual(this.bytes, symmetricSecretKey.bytes);
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        this.checkApprovedOnlyModeStatus();
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.bytes);
        return n;
    }

    final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsOperationError("attempt to use key created in " + (this.approvedModeOnly ? "approved mode" : "unapproved mode") + " in alternate mode.");
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (this.hasBeenDestroyed.compareAndSet(false, true)) {
            this.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    private void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
    }
}

