/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;

public class QueryBitSetProducer
implements BitSetProducer {
    private final Query query;
    final Map<IndexReader.CacheKey, BitSet> cache = Collections.synchronizedMap(new WeakHashMap());
    private static final BitSet SENTINEL = new FixedBitSet(0);

    public QueryBitSetProducer(Query query) {
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public BitSet getBitSet(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        IndexReader.CacheHelper cacheHelper = reader.getCoreCacheHelper();
        BitSet bitSet = null;
        if (cacheHelper != null) {
            bitSet = this.cache.get(cacheHelper.getKey());
        }
        if (bitSet == null) {
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Query rewritten = searcher.rewrite(this.query);
            Weight weight = searcher.createWeight(rewritten, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = weight.scorer(context);
            bitSet = s == null ? SENTINEL : BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc());
            if (cacheHelper != null) {
                this.cache.put(cacheHelper.getKey(), bitSet);
            }
        }
        return bitSet == SENTINEL ? null : bitSet;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.query.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryBitSetProducer other = (QueryBitSetProducer)o;
        return this.query.equals((Object)other.query);
    }

    public int hashCode() {
        return 31 * this.getClass().hashCode() + this.query.hashCode();
    }
}

