/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.IndicesRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.index.Index;
import org.opensearch.search.pipeline.SearchPipelineService;

public class NeuralSearchClusterUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(NeuralSearchClusterUtil.class);
    private ClusterService clusterService;
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private SearchPipelineService searchPipelineService;
    private static NeuralSearchClusterUtil instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NeuralSearchClusterUtil instance() {
        if (instance != null) return instance;
        Class<NeuralSearchClusterUtil> clazz = NeuralSearchClusterUtil.class;
        synchronized (NeuralSearchClusterUtil.class) {
            if (instance != null) return instance;
            instance = new NeuralSearchClusterUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public Version getClusterMinVersion() {
        return this.clusterService.state().getNodes().getMinNodeVersion();
    }

    public List<IndexMetadata> getIndexMetadataList(@NonNull IndicesRequest searchRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest is marked non-null but is null");
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(this.clusterService.state(), searchRequest);
        return Arrays.stream(concreteIndices).map(concreteIndex -> this.clusterService.state().metadata().index(concreteIndex)).collect(Collectors.toList());
    }

    public Map<String, String> getIndexMapping(String[] indices) {
        try {
            if (indices != null && indices.length > 0) {
                return Arrays.stream(indices).filter(indexName -> {
                    IndexMetadata indexMetadata = this.clusterService.state().metadata().index(indexName);
                    return indexMetadata != null && indexMetadata.mapping() != null;
                }).collect(Collectors.toMap(indexName -> indexName, indexName -> {
                    IndexMetadata indexMetadata = this.clusterService.state().metadata().index(indexName);
                    return indexMetadata.mapping().source().toString();
                }));
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract index mapping", (Throwable)e);
            throw new IllegalStateException("Failed to extract index mapping", e);
        }
        throw new IllegalStateException("No valid index found to extract mapping");
    }

    public boolean isSystemGeneratedFactoryEnabled(String factoryName) {
        if (this.searchPipelineService == null) {
            throw new IllegalStateException("search pipeline service is not initialized in the neural search cluster util.");
        }
        return this.searchPipelineService.isSystemGeneratedFactoryEnabled(factoryName);
    }

    @Generated
    private NeuralSearchClusterUtil() {
    }

    @Generated
    public ClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public void setSearchPipelineService(SearchPipelineService searchPipelineService) {
        this.searchPipelineService = searchPipelineService;
    }
}

