/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.neuralsearch.sparse.SparseSettings;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorFieldType;

public class SparseFieldUtils {
    public static Set<String> getSparseAnnFields(String index, ClusterService clusterService) {
        long maxDepth = SparseFieldUtils.getMaxDepth(index, clusterService);
        return SparseFieldUtils.getSparseAnnFields(index, clusterService, maxDepth);
    }

    public static Set<String> getSparseAnnFields(String index, ClusterService clusterService, long maxDepth) {
        if (index == null) {
            return Collections.emptySet();
        }
        IndexMetadata metadata = Optional.ofNullable(clusterService).map(ClusterService::state).map(ClusterState::metadata).map(metadataState -> metadataState.index(index)).orElse(null);
        if (metadata == null || !((Boolean)SparseSettings.IS_SPARSE_INDEX_SETTING.get(metadata.getSettings())).booleanValue()) {
            return Collections.emptySet();
        }
        MappingMetadata mappingMetadata = metadata.mapping();
        if (mappingMetadata == null || mappingMetadata.sourceAsMap() == null) {
            return Collections.emptySet();
        }
        Object properties = mappingMetadata.sourceAsMap().get("properties");
        if (!(properties instanceof Map)) {
            return Collections.emptySet();
        }
        HashSet<String> sparseAnnFields = new HashSet<String>();
        Map fields = (Map)properties;
        SparseFieldUtils.collectSparseAnnFields(fields, "", sparseAnnFields, 1, maxDepth);
        return sparseAnnFields;
    }

    public static long getMaxDepth(String index, ClusterService clusterService) {
        Settings settings = Optional.ofNullable(clusterService).map(ClusterService::state).map(ClusterState::metadata).map(metadata -> metadata.index(index)).map(IndexMetadata::getSettings).orElse(Settings.EMPTY);
        return (Long)MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING.get(settings);
    }

    private static void collectSparseAnnFields(Map<String, Object> fields, String parentPath, Set<String> sparseAnnFields, int depth, long maxDepth) {
        if ((long)depth > maxDepth) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field [%s] exceeds maximum mapping depth limit of [%d]", parentPath, maxDepth));
        }
        for (Map.Entry<String, Object> field : fields.entrySet()) {
            if (!(field.getValue() instanceof Map)) continue;
            Map fieldMap = (Map)field.getValue();
            Object type = fieldMap.get("type");
            if (Objects.nonNull(type) && SparseVectorFieldType.isSparseVectorType(type.toString())) {
                sparseAnnFields.add((String)(parentPath.isEmpty() ? field.getKey() : parentPath + "." + field.getKey()));
                continue;
            }
            Object nestedProperties = fieldMap.get("properties");
            if (!(nestedProperties instanceof Map)) continue;
            String currentPath = parentPath.isEmpty() ? field.getKey() : parentPath + "." + field.getKey();
            SparseFieldUtils.collectSparseAnnFields((Map)nestedProperties, currentPath, sparseAnnFields, depth + 1, maxDepth);
        }
    }
}

