/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;

@SdkPublicApi
@ThreadSafe
public final class GetItemEnhancedResponse<T> {
    private final T attributes;
    private final ConsumedCapacity consumedCapacity;

    private GetItemEnhancedResponse(Builder<T> builder) {
        this.attributes = ((Builder)builder).attributes;
        this.consumedCapacity = ((Builder)builder).consumedCapacity;
    }

    public T attributes() {
        return this.attributes;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetItemEnhancedResponse that = (GetItemEnhancedResponse)o;
        return Objects.equals(this.attributes, that.attributes) && Objects.equals(this.consumedCapacity, that.consumedCapacity);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.consumedCapacity);
        return result;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder<T> {
        private T attributes;
        private ConsumedCapacity consumedCapacity;

        public Builder<T> attributes(T attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder<T> consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public GetItemEnhancedResponse<T> build() {
            return new GetItemEnhancedResponse(this);
        }
    }
}

