SET(CONFUSE_SEARCH_PATHS
    /usr/local/
    /usr
    /opt
)

FIND_PATH(CONFUSE_INCLUDE_DIR confuse.h
    HINTS
    PATH_SUFFIXES include
    PATHS ${CONFUSE_SEARCH_PATHS}
)
FIND_LIBRARY(CONFUSE_LIBRARY confuse
    HINTS
    PATH_SUFFIXES lib64 lib bin
    PATHS ${CONFUSE_SEARCH_PATHS}
)

include(FindPackageHandleStandardArgs)
# handle the QUIETLY and REQUIRED arguments
FIND_PACKAGE_HANDLE_STANDARD_ARGS(confuse
    REQUIRED_VARS CONFUSE_LIBRARY CONFUSE_INCLUDE_DIR
)

mark_as_advanced(CONFUSE_INCLUDE_DIR CONFUSE_LIBRARY CONFUSE_SEARCH_PATHS)
