//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// デバッガ (M680x0 依存部分)
//

#pragma once

#include "debugger_private.h"
#include "mpu680x0.h"
#include "m680x0disasm.h"

class StackData;

class DebuggerMD_m680x0 : public DebuggerMD
{
	using inherited = DebuggerMD;
 public:
	explicit DebuggerMD_m680x0(Debugger *parent);
	~DebuggerMD_m680x0() override;

	CPUState GetCPUState() const override { return (CPUState)cpu->GetState(); }
	bool IsSuper() const override { return cpu->IsSuper(); }
	bool MMUEnabled() const override { return cpu->mmu_enable; }
	busaddr TranslateAddr(busaddr laddr) const override;

	uint32 GetPC() const override { return cpu->reg.pc; }
	int32 GetAndResetLastVector() override {
		return cpu->GetAndResetLastVector();
	}

	void SetStepOut() override;
	bool IsStepOut() const override;
	bool IsOpStepIn(DebuggerMemoryStream& mem) override;
	uint64 GetRegAddr(const char *name) const override;
	void BackupRegs() override { prev = cpu->reg; }
	bool ShowRegister(FILE *, const std::vector<std::string>& args) override;
	const HelpMessages& GetHelpListReg() const override;
	const HelpMessages& GetHelpReg() const override;

	bool CheckLEA(uint32 laddr) override { return false; }

	std::string Disassemble(DebuggerMemoryStream& mem) override;
	std::string ParseInst(const std::string&) const override;

	void PrintExceptionFrame(FILE *, busaddr) override;

	// 浮動小数点ステートフレームを表示する。
	void PrintFPStateFrame(FILE *, busaddr);

 private:
	MPU680x0Device *cpu {};	// MPU デバイス
	m68kreg prev {};		// 前回のレジスタセットのコピー

	static bool IsOPcc(uint16 op);
	static bool IsDBcc(uint16 op);
	static int  IsFXcc(const std::vector<uint16>& ir);
	bool IsCond(uint16 op) const;
	const char *CondStr(const std::vector<uint16>& ir) const;

	static const HelpMessages HelpListReg;
	static const HelpMessages HelpReg;
	void ShowRegMain(FILE *);
	void ShowRegFPU(FILE *);
	void ShowRegMMU30(FILE *);
	void ShowRegMMU40(FILE *);
	void ShowRegATC();
	void ShowRegOther();

	bool PrintExceptionFrameCommon(FILE *, const StackData&, bool);
	void PrintExceptionFrame0(FILE *, StackData&);
	void PrintExceptionFrame2(FILE *, StackData&);
	void PrintExceptionFrame3(FILE *, StackData&);
	void PrintExceptionFrame4(FILE *, StackData&);
	void PrintExceptionFrame7(FILE *, StackData&);
	void PrintExceptionFrameB(FILE *, StackData&);

	void PrintFPFrame6888xIdle(FILE *, StackData&, uint32 len);
	void PrintFPFrame6888xBusy(FILE *, StackData&, uint32 len);
	void PrintFPFrame68040Unimpl(FILE *, StackData&, uint base);
	void PrintFPFrame68040Busy(FILE *, StackData&);

	uint32 so_a7 {};			// ステップアウト判定用
	uint16 so_sr {};
};
