package libtimetest

// Code generated by http://github.com/gojuno/minimock (dev). DO NOT EDIT.

import (
	"sync"
	mm_atomic "sync/atomic"
	"time"
	mm_time "time"

	"github.com/gojuno/minimock/v3"
)

// SleeperMock implements libtime.Sleeper
type SleeperMock struct {
	t minimock.Tester

	funcSleep          func(d1 time.Duration)
	inspectFuncSleep   func(d1 time.Duration)
	afterSleepCounter  uint64
	beforeSleepCounter uint64
	SleepMock          mSleeperMockSleep
}

// NewSleeperMock returns a mock for libtime.Sleeper
func NewSleeperMock(t minimock.Tester) *SleeperMock {
	m := &SleeperMock{t: t}
	if controller, ok := t.(minimock.MockController); ok {
		controller.RegisterMocker(m)
	}

	m.SleepMock = mSleeperMockSleep{mock: m}
	m.SleepMock.callArgs = []*SleeperMockSleepParams{}

	return m
}

type mSleeperMockSleep struct {
	mock               *SleeperMock
	defaultExpectation *SleeperMockSleepExpectation
	expectations       []*SleeperMockSleepExpectation

	callArgs []*SleeperMockSleepParams
	mutex    sync.RWMutex
}

// SleeperMockSleepExpectation specifies expectation struct of the Sleeper.Sleep
type SleeperMockSleepExpectation struct {
	mock   *SleeperMock
	params *SleeperMockSleepParams

	Counter uint64
}

// SleeperMockSleepParams contains parameters of the Sleeper.Sleep
type SleeperMockSleepParams struct {
	d1 time.Duration
}

// Expect sets up expected params for Sleeper.Sleep
func (mmSleep *mSleeperMockSleep) Expect(d1 time.Duration) *mSleeperMockSleep {
	if mmSleep.mock.funcSleep != nil {
		mmSleep.mock.t.Fatalf("SleeperMock.Sleep mock is already set by Set")
	}

	if mmSleep.defaultExpectation == nil {
		mmSleep.defaultExpectation = &SleeperMockSleepExpectation{}
	}

	mmSleep.defaultExpectation.params = &SleeperMockSleepParams{d1}
	for _, e := range mmSleep.expectations {
		if minimock.Equal(e.params, mmSleep.defaultExpectation.params) {
			mmSleep.mock.t.Fatalf("Expectation set by When has same params: %#v", *mmSleep.defaultExpectation.params)
		}
	}

	return mmSleep
}

// Inspect accepts an inspector function that has same arguments as the Sleeper.Sleep
func (mmSleep *mSleeperMockSleep) Inspect(f func(d1 time.Duration)) *mSleeperMockSleep {
	if mmSleep.mock.inspectFuncSleep != nil {
		mmSleep.mock.t.Fatalf("Inspect function is already set for SleeperMock.Sleep")
	}

	mmSleep.mock.inspectFuncSleep = f

	return mmSleep
}

// Return sets up results that will be returned by Sleeper.Sleep
func (mmSleep *mSleeperMockSleep) Return() *SleeperMock {
	if mmSleep.mock.funcSleep != nil {
		mmSleep.mock.t.Fatalf("SleeperMock.Sleep mock is already set by Set")
	}

	if mmSleep.defaultExpectation == nil {
		mmSleep.defaultExpectation = &SleeperMockSleepExpectation{mock: mmSleep.mock}
	}

	return mmSleep.mock
}

//Set uses given function f to mock the Sleeper.Sleep method
func (mmSleep *mSleeperMockSleep) Set(f func(d1 time.Duration)) *SleeperMock {
	if mmSleep.defaultExpectation != nil {
		mmSleep.mock.t.Fatalf("Default expectation is already set for the Sleeper.Sleep method")
	}

	if len(mmSleep.expectations) > 0 {
		mmSleep.mock.t.Fatalf("Some expectations are already set for the Sleeper.Sleep method")
	}

	mmSleep.mock.funcSleep = f
	return mmSleep.mock
}

// Sleep implements libtime.Sleeper
func (mmSleep *SleeperMock) Sleep(d1 time.Duration) {
	mm_atomic.AddUint64(&mmSleep.beforeSleepCounter, 1)
	defer mm_atomic.AddUint64(&mmSleep.afterSleepCounter, 1)

	if mmSleep.inspectFuncSleep != nil {
		mmSleep.inspectFuncSleep(d1)
	}

	mm_params := &SleeperMockSleepParams{d1}

	// Record call args
	mmSleep.SleepMock.mutex.Lock()
	mmSleep.SleepMock.callArgs = append(mmSleep.SleepMock.callArgs, mm_params)
	mmSleep.SleepMock.mutex.Unlock()

	for _, e := range mmSleep.SleepMock.expectations {
		if minimock.Equal(e.params, mm_params) {
			mm_atomic.AddUint64(&e.Counter, 1)
			return
		}
	}

	if mmSleep.SleepMock.defaultExpectation != nil {
		mm_atomic.AddUint64(&mmSleep.SleepMock.defaultExpectation.Counter, 1)
		mm_want := mmSleep.SleepMock.defaultExpectation.params
		mm_got := SleeperMockSleepParams{d1}
		if mm_want != nil && !minimock.Equal(*mm_want, mm_got) {
			mmSleep.t.Errorf("SleeperMock.Sleep got unexpected parameters, want: %#v, got: %#v%s\n", *mm_want, mm_got, minimock.Diff(*mm_want, mm_got))
		}

		return

	}
	if mmSleep.funcSleep != nil {
		mmSleep.funcSleep(d1)
		return
	}
	mmSleep.t.Fatalf("Unexpected call to SleeperMock.Sleep. %v", d1)

}

// SleepAfterCounter returns a count of finished SleeperMock.Sleep invocations
func (mmSleep *SleeperMock) SleepAfterCounter() uint64 {
	return mm_atomic.LoadUint64(&mmSleep.afterSleepCounter)
}

// SleepBeforeCounter returns a count of SleeperMock.Sleep invocations
func (mmSleep *SleeperMock) SleepBeforeCounter() uint64 {
	return mm_atomic.LoadUint64(&mmSleep.beforeSleepCounter)
}

// Calls returns a list of arguments used in each call to SleeperMock.Sleep.
// The list is in the same order as the calls were made (i.e. recent calls have a higher index)
func (mmSleep *mSleeperMockSleep) Calls() []*SleeperMockSleepParams {
	mmSleep.mutex.RLock()

	argCopy := make([]*SleeperMockSleepParams, len(mmSleep.callArgs))
	copy(argCopy, mmSleep.callArgs)

	mmSleep.mutex.RUnlock()

	return argCopy
}

// MinimockSleepDone returns true if the count of the Sleep invocations corresponds
// the number of defined expectations
func (m *SleeperMock) MinimockSleepDone() bool {
	for _, e := range m.SleepMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			return false
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.SleepMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterSleepCounter) < 1 {
		return false
	}
	// if func was set then invocations count should be greater than zero
	if m.funcSleep != nil && mm_atomic.LoadUint64(&m.afterSleepCounter) < 1 {
		return false
	}
	return true
}

// MinimockSleepInspect logs each unmet expectation
func (m *SleeperMock) MinimockSleepInspect() {
	for _, e := range m.SleepMock.expectations {
		if mm_atomic.LoadUint64(&e.Counter) < 1 {
			m.t.Errorf("Expected call to SleeperMock.Sleep with params: %#v", *e.params)
		}
	}

	// if default expectation was set then invocations count should be greater than zero
	if m.SleepMock.defaultExpectation != nil && mm_atomic.LoadUint64(&m.afterSleepCounter) < 1 {
		if m.SleepMock.defaultExpectation.params == nil {
			m.t.Error("Expected call to SleeperMock.Sleep")
		} else {
			m.t.Errorf("Expected call to SleeperMock.Sleep with params: %#v", *m.SleepMock.defaultExpectation.params)
		}
	}
	// if func was set then invocations count should be greater than zero
	if m.funcSleep != nil && mm_atomic.LoadUint64(&m.afterSleepCounter) < 1 {
		m.t.Error("Expected call to SleeperMock.Sleep")
	}
}

// MinimockFinish checks that all mocked methods have been called the expected number of times
func (m *SleeperMock) MinimockFinish() {
	if !m.minimockDone() {
		m.MinimockSleepInspect()
		m.t.FailNow()
	}
}

// MinimockWait waits for all mocked methods to be called the expected number of times
func (m *SleeperMock) MinimockWait(timeout mm_time.Duration) {
	timeoutCh := mm_time.After(timeout)
	for {
		if m.minimockDone() {
			return
		}
		select {
		case <-timeoutCh:
			m.MinimockFinish()
			return
		case <-mm_time.After(10 * mm_time.Millisecond):
		}
	}
}

func (m *SleeperMock) minimockDone() bool {
	done := true
	return done &&
		m.MinimockSleepDone()
}
