/**
 * Copyright IBM Corp. 2015, 2025
 * SPDX-License-Identifier: BUSL-1.1
 */

import Route from '@ember/routing/route';
import classic from 'ember-classic-decorator';
import { inject as service } from '@ember/service';
import { action } from '@ember/object';
import { next } from '@ember/runloop';
import RSVP from 'rsvp';

@classic
export default class OptimizeRoute extends Route {
  @service can;
  @service store;

  beforeModel() {
    if (this.can.cannot('accept recommendation')) {
      this.transitionTo('jobs');
    }
  }

  async model() {
    const summaries = await this.store.findAll('recommendation-summary');
    const jobs = await RSVP.all(summaries.mapBy('job'));
    const [namespaces] = await RSVP.all([
      this.store.findAll('namespace'),
      ...jobs
        .filter((job) => job)
        .filterBy('isPartial')
        .map((j) => j.reload()),
    ]);

    // reload the /allocations for each job,
    // as the jobs-index-provided ones are less detailed than what
    // the optimize/recommendation components require
    await RSVP.all(
      jobs
        .filter((job) => job)
        .map((j) => this.store.query('allocation', { job_id: j.id }))
    );

    return {
      summaries: summaries.sortBy('submitTime').reverse(),
      namespaces,
    };
  }

  @action
  reachedEnd() {
    this.store.unloadAll('recommendation-summary');

    next(() => {
      this.transitionTo('optimize');
      this.refresh();
    });
  }
}
