/**
 * Copyright IBM Corp. 2015, 2025
 * SPDX-License-Identifier: BUSL-1.1
 */

// playwright.config.js
// @ts-check
const { devices } = require('@playwright/test');

export const STORAGE_STATE = 'storageState.json';

/** @type {import('@playwright/test').PlaywrightTestConfig} */
const config = {
  forbidOnly: !!process.env.CI,
  retries: process.env.CI ? 2 : 0,
  use: {
    trace: 'on-first-retry',
    ignoreHTTPSErrors: true,
  },
  globalSetup: require.resolve('./global-setup'),
  projects: [
    {
      name: 'chromium',
      use: {
        ...devices['Desktop Chrome'],
        storageState: STORAGE_STATE,
      },
    },
    // disabling firefox temporarily because the container doesn't
    // include it and so it tries to automatically install it and
    // that takes longer than the timeout (30s). once we've got
    // some value out of these tests we can customize the container
    // {
    //   name: 'firefox',
    //   use: { ...devices['Desktop Firefox'] },
    // },
    {
      name: 'webkit',
      use: {
        ...devices['Desktop Safari'],
        storageState: STORAGE_STATE,
      },
    },
  ],
};

module.exports = config;
