# Copyright IBM Corp. 2015, 2025
# SPDX-License-Identifier: BUSL-1.1

id        = "ebs-vol[0]"
name      = "idempotency-token" # CSIVolumeName tag, must be idempotent
type      = "csi"
plugin_id = "aws-ebs0"

capacity_min = "10GiB"
capacity_max = "20GiB"

capability {
  access_mode     = "single-node-writer"
  attachment_mode = "file-system"
}

capability {
  access_mode     = "single-node-writer"
  attachment_mode = "block-device"
}

parameters {
  type = "gp2"

  # ref https://github.com/kubernetes-sigs/aws-ebs-csi-driver/blob/master/docs/tagging.md#storageclass-tagging
  tagSpecification_1 = "Name=e2e-testing-vol0"
}

topology_request {
  required {
    topology {
      segments {
        # this zone should match the one set in e2e/terraform/variables.tf
        "topology.ebs.csi.aws.com/zone" = "us-east-1b"
      }
    }
  }
}
