/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.api.facesmodel.Description;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.dialogs.AddDialog;
import org.netbeans.modules.web.jsf.dialogs.AddManagedBeanDialog;
import org.netbeans.modules.web.jsf.dialogs.AddNavigationCaseDialog;
import org.netbeans.modules.web.jsf.dialogs.AddNavigationRuleDialog;
import org.netbeans.modules.web.jsf.impl.facesmodel.JSFConfigModelUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class JsfPopupAction
extends SystemAction
implements Presenter.Popup {
    private ArrayList actions = null;
    protected static final int MANAGED_BEAN_TYPE = 1;
    protected static final int NAVIGATION_RULE_TYPE = 2;

    public String getName() {
        return NbBundle.getMessage(JsfPopupAction.class, (String)"org-netbeans-modules-web-jsf-editor-JSFPopupAction.instance");
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getPopupPresenter() {
        return new SubMenu(this.getName());
    }

    public class SubMenu
    extends JMenu {
        public SubMenu(String s) {
            super(s);
        }

        @Override
        public JPopupMenu getPopupMenu() {
            JPopupMenu pm = super.getPopupMenu();
            pm.removeAll();
            pm.add((Action)((Object)new AddNavigationRuleAction()));
            pm.add((Action)((Object)new AddNavigationCaseAction()));
            pm.add(new JSeparator());
            pm.add((Action)((Object)new AddManagedBeanAction()));
            pm.pack();
            return pm;
        }
    }

    public static class AddNavigationCaseAction
    extends BaseAction {
        public AddNavigationCaseAction() {
            super(NbBundle.getBundle(JsfPopupAction.class).getString("add-navigation-case-action"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseDocument doc = (BaseDocument)target.getDocument();
            JSFConfigDataObject data = (JSFConfigDataObject)NbEditorUtilities.getDataObject((Document)doc);
            AddNavigationCaseDialog dialogPanel = new AddNavigationCaseDialog(data, JSFEditorUtilities.getNavigationRule(doc, target.getCaretPosition()));
            AddDialog dialog = new AddDialog(dialogPanel, NbBundle.getMessage(JsfPopupAction.class, (String)"TTL_AddNavigationCase"), new HelpCtx("org.netbeans.modules.web.jsf.dialogs.AddNavigationCaseDialog"));
            dialog.disableAdd();
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            if (dialog.getValue().equals(AddDialog.ADD_OPTION)) {
                try {
                    NavigationRule[] rule;
                    final FacesConfig facesConfig = ConfigurationUtils.getConfigModel(data.getPrimaryFile(), true).getRootComponent();
                    boolean newRule = false;
                    String fromView = dialogPanel.getRule();
                    if (fromView.length() == 0) {
                        fromView = null;
                    }
                    if ((rule = new NavigationRule[]{JSFConfigUtilities.findNavigationRule(data, fromView)})[0] == null) {
                        rule[0] = facesConfig.getModel().getFactory().createNavigationRule();
                        rule[0].setFromViewId(fromView);
                        JSFConfigModelUtilities.doInTransaction(facesConfig.getModel(), new Runnable(){

                            @Override
                            public void run() {
                                facesConfig.addNavigationRule(rule[0]);
                            }
                        });
                        newRule = true;
                    }
                    final NavigationCase nCase = facesConfig.getModel().getFactory().createNavigationCase();
                    if (dialogPanel.getFromAction() != null && !dialogPanel.getFromAction().equals("")) {
                        nCase.setFromAction(dialogPanel.getFromAction());
                    }
                    if (dialogPanel.getFromOutcome() != null && !dialogPanel.getFromOutcome().equals("")) {
                        nCase.setFromOutcome(dialogPanel.getFromOutcome());
                    }
                    nCase.setRedirected(dialogPanel.isRedirect());
                    nCase.setToViewId(dialogPanel.getToView());
                    if (dialogPanel.getDescription() != null && !dialogPanel.getDescription().equals("")) {
                        Description description = nCase.getModel().getFactory().createDescription();
                        description.setValue(dialogPanel.getDescription());
                        nCase.addDescription(description);
                    }
                    JSFConfigModelUtilities.doInTransaction(facesConfig.getModel(), new Runnable(){

                        @Override
                        public void run() {
                            rule[0].addNavigationCase(nCase);
                        }
                    });
                    JSFConfigModelUtilities.saveChanges(facesConfig.getModel());
                    if (newRule) {
                        target.setCaretPosition(rule[0].findPosition());
                    } else {
                        target.setCaretPosition(nCase.findPosition());
                    }
                }
                catch (IllegalStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public static class AddNavigationRuleAction
    extends BaseAction {
        public AddNavigationRuleAction() {
            super(NbBundle.getBundle(JsfPopupAction.class).getString("add-navigation-rule-action"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseDocument doc = (BaseDocument)target.getDocument();
            JSFConfigDataObject data = (JSFConfigDataObject)NbEditorUtilities.getDataObject((Document)doc);
            AddNavigationRuleDialog dialogPanel = new AddNavigationRuleDialog(data);
            AddDialog dialog = new AddDialog(dialogPanel, NbBundle.getMessage(JsfPopupAction.class, (String)"TTL_AddNavigationRule"), new HelpCtx("org.netbeans.modules.web.jsf.dialogs.AddNavigationRuleDialog"));
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            if (dialog.getValue().equals(AddDialog.ADD_OPTION)) {
                try {
                    JSFConfigModel model = ConfigurationUtils.getConfigModel(data.getPrimaryFile(), true);
                    final FacesConfig facesConfig = model.getRootComponent();
                    final NavigationRule rule = facesConfig.getModel().getFactory().createNavigationRule();
                    String descriptionText = dialogPanel.getDescription();
                    if (descriptionText != null && descriptionText.trim().length() > 0) {
                        Description description = facesConfig.getModel().getFactory().createDescription();
                        description.setValue(descriptionText);
                        rule.addDescription(description);
                    }
                    if (dialogPanel.getFromView() != null && dialogPanel.getFromView().trim().length() > 0) {
                        rule.setFromViewId(dialogPanel.getFromView());
                    }
                    JSFConfigModelUtilities.doInTransaction(facesConfig.getModel(), new Runnable(){

                        @Override
                        public void run() {
                            facesConfig.addNavigationRule(rule);
                        }
                    });
                    JSFConfigModelUtilities.saveChanges(facesConfig.getModel());
                    target.setCaretPosition(rule.findPosition());
                }
                catch (IllegalStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public static class AddManagedBeanAction
    extends BaseAction {
        public AddManagedBeanAction() {
            super(NbBundle.getBundle(JsfPopupAction.class).getString("add-managed-bean-action"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseDocument doc = (BaseDocument)target.getDocument();
            JSFConfigDataObject data = (JSFConfigDataObject)NbEditorUtilities.getDataObject((Document)doc);
            AddManagedBeanDialog dialogPanel = new AddManagedBeanDialog(data);
            AddDialog dialog = new AddDialog(dialogPanel, NbBundle.getMessage(JsfPopupAction.class, (String)"TTL_AddManagedBean"), new HelpCtx("org.netbeans.modules.web.jsf.dialogs.AddManagedBeanDialog"));
            dialog.disableAdd();
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            if (dialog.getValue().equals(AddDialog.ADD_OPTION)) {
                try {
                    final FacesConfig facesConfig = ConfigurationUtils.getConfigModel(data.getPrimaryFile(), true).getRootComponent();
                    final ManagedBean bean = facesConfig.getModel().getFactory().createManagedBean();
                    bean.setManagedBeanName(dialogPanel.getManagedBeanName());
                    bean.setManagedBeanClass(dialogPanel.getBeanClass());
                    bean.setManagedBeanScope(dialogPanel.getScope());
                    if (dialogPanel.getManagedBeanDescription() != null && dialogPanel.getManagedBeanDescription().trim().length() > 0) {
                        Description description = facesConfig.getModel().getFactory().createDescription();
                        description.setValue(dialogPanel.getManagedBeanDescription());
                        bean.addDescription(description);
                    }
                    JSFConfigModelUtilities.doInTransaction(facesConfig.getModel(), new Runnable(){

                        @Override
                        public void run() {
                            facesConfig.addManagedBean(bean);
                        }
                    });
                    JSFConfigModelUtilities.saveChanges(facesConfig.getModel());
                    target.setCaretPosition(bean.findPosition());
                }
                catch (IllegalStateException ex) {
                    Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }
}

