/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.modules.java.source.ui.LspElementUtils;
import org.netbeans.modules.java.ui.ElementHeaderFormater;

public final class ElementHeaders {
    public static final String ANNOTATIONS = "%annotations%";
    public static final String NAME = "%name%";
    public static final String TYPE = "%type%";
    public static final String THROWS = "%throws%";
    public static final String IMPLEMENTS = "%implements%";
    public static final String EXTENDS = "%extends%";
    public static final String TYPEPARAMETERS = "%typeparameters%";
    public static final String FLAGS = "%flags%";
    public static final String PARAMETERS = "%parameters%";

    private ElementHeaders() {
    }

    public static String getHeader(TreePath treePath, CompilationInfo info, String formatString) {
        assert (info != null);
        assert (treePath != null);
        Element element = info.getTrees().getElement(treePath);
        if (element != null) {
            return ElementHeaders.getHeader(element, info, formatString);
        }
        return null;
    }

    public static String getHeader(Element element, CompilationInfo info, String formatString) {
        assert (element != null);
        assert (info != null);
        assert (formatString != null);
        TreePath tp = info.getTrees().getPath(element);
        if (tp != null) {
            Tree tree = tp.getLeaf();
            if (tree.getKind() == Tree.Kind.METHOD) {
                while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                    tp = tp.getParentPath();
                }
                ClassTree enclosingClass = tp != null ? (ClassTree)tp.getLeaf() : null;
                return ElementHeaderFormater.getMethodHeader((MethodTree)((MethodTree)tree), (ClassTree)enclosingClass, (CompilationInfo)info, (String)formatString);
            }
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                return ElementHeaderFormater.getClassHeader((ClassTree)((ClassTree)tree), (CompilationInfo)info, (String)formatString);
            }
            if (tree.getKind() == Tree.Kind.VARIABLE) {
                return ElementHeaderFormater.getVariableHeader((VariableTree)((VariableTree)tree), (CompilationInfo)info, (String)formatString);
            }
        }
        return formatString.replaceAll(NAME, element.getSimpleName().toString()).replaceAll("%[a-z]*%", "");
    }

    public static int getDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = ElementHeaders.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int min(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    @CheckForNull
    public static StructureElement toStructureElement(CompilationInfo info, Element el, ElementUtilities.ElementAcceptor childAcceptor) {
        return LspElementUtils.element2StructureElement(info, el, childAcceptor);
    }

    public static CompletableFuture<StructureElement> resolveStructureElement(CompilationInfo info, Element el, boolean resolveSources) {
        return LspElementUtils.createStructureElement(info, el, resolveSources);
    }

    public static StructureElement convertElement(CompilationInfo info, Element el, ElementUtilities.ElementAcceptor childAcceptor, boolean allowBinary) {
        return LspElementUtils.describeElement(info, el, childAcceptor, allowBinary);
    }

    public static StructureElement.Kind javaKind2Structure(Element el) {
        ElementKind kind = el.getKind();
        switch (kind) {
            case PACKAGE: {
                return StructureElement.Kind.Package;
            }
            case ENUM: {
                return StructureElement.Kind.Enum;
            }
            case CLASS: 
            case RECORD: {
                return StructureElement.Kind.Class;
            }
            case ANNOTATION_TYPE: {
                return StructureElement.Kind.Interface;
            }
            case INTERFACE: {
                return StructureElement.Kind.Interface;
            }
            case ENUM_CONSTANT: 
            case RECORD_COMPONENT: {
                return StructureElement.Kind.EnumMember;
            }
            case FIELD: {
                return StructureElement.Kind.Field;
            }
            case PARAMETER: {
                return StructureElement.Kind.Variable;
            }
            case LOCAL_VARIABLE: {
                return StructureElement.Kind.Variable;
            }
            case EXCEPTION_PARAMETER: {
                return StructureElement.Kind.Variable;
            }
            case METHOD: {
                return StructureElement.Kind.Method;
            }
            case CONSTRUCTOR: {
                return StructureElement.Kind.Constructor;
            }
            case TYPE_PARAMETER: {
                return StructureElement.Kind.TypeParameter;
            }
            case RESOURCE_VARIABLE: {
                return StructureElement.Kind.Variable;
            }
            case MODULE: {
                return StructureElement.Kind.Module;
            }
        }
        return StructureElement.Kind.File;
    }
}

