/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.persistence.action.GenerationOptions;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_2.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.EntityManagerGenerationStrategy;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public abstract class EntityManagerGenerationStrategySupport
implements EntityManagerGenerationStrategy {
    protected static final String ENTITY_MANAGER_FQN = "javax.persistence.EntityManager";
    private static final String ENTITY_MANAGER_JAKARTA_FQN = "jakarta.persistence.EntityManager";
    protected static final String ENTITY_MANAGER_FACTORY_FQN = "javax.persistence.EntityManagerFactory";
    private static final String ENTITY_MANAGER_FACTORY_JAKARTA_FQN = "jakarta.persistence.EntityManagerFactory";
    protected static final String USER_TX_FQN = "javax.transaction.UserTransaction";
    private static final String USER_TX_JAKARTA_FQN = "jakarta.transaction.UserTransaction";
    protected static final String PERSISTENCE_CONTEXT_FQN = "javax.persistence.PersistenceContext";
    private static final String PERSISTENCE_CONTEXT_JAKARTA_FQN = "jakarta.persistence.PersistenceContext";
    protected static final String PERSISTENCE_UNIT_FQN = "javax.persistence.PersistenceUnit";
    private static final String PERSISTENCE_UNIT_JAKARTA_FQN = "jakarta.persistence.PersistenceUnit";
    protected static final String POST_CONSTRUCT_FQN = "javax.annotation.PostConstruct";
    private static final String POST_CONSTRUCT_JAKARTA_FQN = "jakarta.annotation.PostConstruct";
    protected static final String PRE_DESTROY_FQN = "javax.annotation.PreDestroy";
    private static final String PRE_DESTROY_JAKARTA_FQN = "jakarta.annotation.PreDestroy";
    protected static final String RESOURCE_FQN = "javax.annotation.Resource";
    private static final String RESOURCE_JAKARTA_FQN = "jakarta.annotation.Resource";
    protected static final String ENTITY_MANAGER_DEFAULT_NAME = "em";
    protected static final String ENTITY_MANAGER_FACTORY_DEFAULT_NAME = "emf";
    private TreeMaker treeMaker;
    private ClassTree classTree;
    private WorkingCopy workingCopy;
    private GenerationUtils genUtils;
    private org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit;
    private GenerationOptions generationOptions;

    protected List<VariableTree> getParameterList() {
        if (this.getGenerationOptions().getParameterType() == null) {
            return Collections.emptyList();
        }
        VariableTree parameter = this.getTreeMaker().Variable(this.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)this.getGenerationOptions().getParameterName(), this.getGenUtils().createType(this.getGenerationOptions().getParameterType(), this.getClassElement()), null);
        return Collections.singletonList(parameter);
    }

    protected Tree getReturnTypeTree() {
        if (this.getGenerationOptions().getReturnType() == null || "void".equals(this.getGenerationOptions().getReturnType())) {
            return this.getTreeMaker().PrimitiveType(TypeKind.VOID);
        }
        return this.getGenUtils().createType(this.getGenerationOptions().getReturnType(), this.getClassElement());
    }

    protected Tree importFQNs(Tree tree) {
        return GeneratorUtilities.get((WorkingCopy)this.getWorkingCopy()).importFQNs(tree);
    }

    protected String computeMethodName() {
        return this.makeUnique(this.getGenerationOptions().getMethodName());
    }

    private String makeUnique(String methodName) {
        List<? extends Tree> members = this.getClassTree().getMembers();
        Object name = methodName;
        int add = 1;
        boolean found = false;
        do {
            found = false;
            for (Tree tree : members) {
                MethodTree mt;
                if (Tree.Kind.METHOD != tree.getKind() || (mt = tree instanceof MethodTree ? (MethodTree)tree : null) == null || !((String)name).equals(mt.getName().toString())) continue;
                found = true;
                name = methodName + add++;
            }
        } while (found);
        return name;
    }

    FieldInfo getEntityManagerFactoryFieldInfo() {
        VariableTree existing = this.getField(this.getEntityManagerFactoryFqn());
        if (existing != null) {
            return new FieldInfo(existing.getName().toString(), true);
        }
        return new FieldInfo(ENTITY_MANAGER_FACTORY_DEFAULT_NAME, false);
    }

    FieldInfo getEntityManagerFieldInfo() {
        VariableTree existing = this.getField(this.getEntityManagerFqn());
        if (existing != null) {
            return new FieldInfo(existing.getName().toString(), true);
        }
        return new FieldInfo(ENTITY_MANAGER_DEFAULT_NAME, false);
    }

    protected VariableTree getField(String fieldTypeFqn) {
        Parameters.notEmpty((CharSequence)"fieldTypeFqn", (CharSequence)fieldTypeFqn);
        for (Tree tree : this.getClassTree().getMembers()) {
            if (Tree.Kind.VARIABLE != tree.getKind()) continue;
            VariableTree variable = (VariableTree)tree;
            TreePath path = this.getWorkingCopy().getTrees().getPath(this.getWorkingCopy().getCompilationUnit(), variable);
            TypeMirror variableType = this.getWorkingCopy().getTrees().getTypeMirror(path);
            if (!fieldTypeFqn.equals(variableType.toString())) continue;
            return variable;
        }
        return null;
    }

    protected Element getAnnotation(String annotationTypeFqn) {
        Parameters.notEmpty((CharSequence)"annotationTypeFqn", (CharSequence)annotationTypeFqn);
        TypeElement annotationType = this.asTypeElement(annotationTypeFqn);
        TypeElement classElement = this.getClassElement();
        ArrayList<Element> elements = new ArrayList<Element>();
        elements.add(classElement);
        elements.addAll(ElementFilter.fieldsIn(classElement.getEnclosedElements()));
        elements.addAll(ElementFilter.methodsIn(classElement.getEnclosedElements()));
        return this.checkElementsForAnnotationType(elements, annotationType);
    }

    private Element checkElementsForType(List<? extends Element> elements, TypeElement type) {
        for (Element element : elements) {
            if (!this.getWorkingCopy().getTypes().isSameType(element.asType(), type.asType())) continue;
            return type;
        }
        return null;
    }

    private Element checkElementsForAnnotationType(List<? extends Element> elements, TypeElement annotationType) {
        for (Element element : elements) {
            for (AnnotationMirror annotationMirror : this.getWorkingCopy().getElements().getAllAnnotationMirrors(element)) {
                if (!this.getWorkingCopy().getTypes().isSameType(annotationType.asType(), ((TypeElement)annotationMirror.getAnnotationType().asElement()).asType())) continue;
                return annotationType;
            }
        }
        return null;
    }

    TypeElement getClassElement() {
        TreePath path = this.getWorkingCopy().getTrees().getPath(this.getWorkingCopy().getCompilationUnit(), this.getClassTree());
        return (TypeElement)this.getWorkingCopy().getTrees().getElement(path);
    }

    private TypeElement asTypeElement(String fqn) {
        TypeElement result = this.getWorkingCopy().getElements().getTypeElement(fqn);
        assert (result != null) : "Could not get TypeElement for " + fqn;
        return result;
    }

    protected String generateCallLines() {
        return this.generateCallLines(ENTITY_MANAGER_DEFAULT_NAME);
    }

    protected String getEmInitCode(FieldInfo em, FieldInfo emf) {
        String text = "javax.persistence.EntityManager {0} = {1}.createEntityManager();\n";
        return MessageFormat.format(text, em.getName(), emf.getName());
    }

    protected String generateCallLines(String emName) {
        return MessageFormat.format(this.getGenerationOptions().getOperation().getBody(this.getPersistenceVersion()), emName, this.getGenerationOptions().getParameterName(), this.getGenerationOptions().getParameterType(), this.getGenerationOptions().getReturnType(), this.getGenerationOptions().getQueryAttribute());
    }

    protected VariableTree createUserTransaction() {
        VariableTree result = this.getTreeMaker().Variable(this.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(this.getGenUtils().createAnnotation(this.getResourceFqn()))), (CharSequence)"utx", (Tree)this.getTreeMaker().Identifier((CharSequence)this.getUserTxFqn()), null);
        result = (VariableTree)this.importFQNs(result);
        return result;
    }

    protected VariableTree createEntityManagerFactory(String name) {
        return this.getTreeMaker().Variable(this.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)name, (Tree)this.getTypeTree(this.getEntityManagerFactoryFqn()), (ExpressionTree)this.getTreeMaker().MethodInvocation(Collections.emptyList(), (ExpressionTree)this.getTreeMaker().MemberSelect(this.getTypeTree("javax.persistence.Persistence"), (CharSequence)"createEntityManagerFactory"), Collections.singletonList(this.getTreeMaker().Literal((Object)this.getPersistenceUnitName()))));
    }

    protected String getPersistenceUnitName() {
        return this.getPersistenceUnit() != null ? this.getPersistenceUnit().getName() : "";
    }

    protected ExpressionTree getTypeTree(String fqn) {
        return this.getTreeMaker().QualIdent((Element)this.getWorkingCopy().getElements().getTypeElement(fqn));
    }

    protected ClassTree createEntityManager(Initialization init) {
        ClassTree result = this.getClassTree();
        ArrayList<AnnotationTree> anns = new ArrayList<AnnotationTree>();
        LiteralTree expressionTree = null;
        String emfName = ENTITY_MANAGER_FACTORY_DEFAULT_NAME;
        boolean needsEmf = false;
        VariableTree existingEmf = null;
        switch (init) {
            case INJECT: {
                anns.add(this.getGenUtils().createAnnotation(this.getPersistenceContextFqn(), Collections.singletonList(this.getGenUtils().createAnnotationArgument("unitName", (Object)this.getPersistenceUnitName()))));
                break;
            }
            case EMF: {
                existingEmf = this.getField(this.getEntityManagerFactoryFqn());
                assert (existingEmf != null) : "EntityManagerFactory does not exist in the class";
                expressionTree = this.getTreeMaker().Literal((Object)(existingEmf.getName().toString() + ".createEntityManager();"));
                break;
            }
            case INIT: {
                existingEmf = this.getField(this.getEntityManagerFactoryFqn());
                if (existingEmf != null) {
                    emfName = existingEmf.getName().toString();
                } else {
                    needsEmf = true;
                }
                AnnotationTree postConstruct = this.getGenUtils().createAnnotation(this.getPostConstructFqn());
                MethodTree initMethod = this.getTreeMaker().Method(this.getTreeMaker().Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(postConstruct)), (CharSequence)this.makeUnique("init"), (Tree)this.getTreeMaker().PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ em = " + emfName + ".createEntityManager(); }", null);
                result = this.getTreeMaker().addClassMember(this.getClassTree(), (Tree)initMethod);
                AnnotationTree preDestroy = this.getGenUtils().createAnnotation(this.getPreDestroyFqn());
                MethodTree destroyMethod = this.getTreeMaker().Method(this.getTreeMaker().Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(preDestroy)), (CharSequence)this.makeUnique("destroy"), (Tree)this.getTreeMaker().PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ em .close(); }", null);
                result = this.getTreeMaker().addClassMember(result, (Tree)destroyMethod);
                if (!needsEmf) break;
                ExpressionTree annArgument = this.getGenUtils().createAnnotationArgument("name", (Object)this.getPersistenceUnitName());
                AnnotationTree puAnn = this.getGenUtils().createAnnotation(this.getPersistenceUnitFqn(), Collections.singletonList(annArgument));
                VariableTree emf = this.getTreeMaker().Variable(this.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(puAnn)), (CharSequence)emfName, (Tree)this.getTypeTree(this.getEntityManagerFactoryFqn()), null);
                result = this.getTreeMaker().insertClassMember(result, this.getIndexForField(result), (Tree)emf);
            }
        }
        VariableTree entityManager = this.getTreeMaker().Variable(this.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE), anns), (CharSequence)ENTITY_MANAGER_DEFAULT_NAME, (Tree)this.getTypeTree(this.getEntityManagerFqn()), (ExpressionTree)expressionTree);
        return this.getTreeMaker().insertClassMember(result, this.getIndexForField(result), (Tree)entityManager);
    }

    protected int getIndexForField(ClassTree clazz) {
        int result = 0;
        for (Tree tree : clazz.getMembers()) {
            if (Tree.Kind.VARIABLE != tree.getKind()) continue;
            ++result;
        }
        return result;
    }

    protected TreeMaker getTreeMaker() {
        return this.treeMaker;
    }

    @Override
    public void setTreeMaker(TreeMaker treeMaker) {
        this.treeMaker = treeMaker;
    }

    protected ClassTree getClassTree() {
        return this.classTree;
    }

    @Override
    public void setClassTree(ClassTree classTree) {
        this.classTree = classTree;
    }

    protected WorkingCopy getWorkingCopy() {
        return this.workingCopy;
    }

    @Override
    public void setWorkingCopy(WorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    protected GenerationUtils getGenUtils() {
        if (this.genUtils == null) {
            this.genUtils = GenerationUtils.newInstance((WorkingCopy)this.getWorkingCopy());
        }
        return this.genUtils;
    }

    @Override
    public void setGenUtils(GenerationUtils genUtils) {
        this.genUtils = genUtils;
    }

    protected org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public void setPersistenceUnit(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    protected GenerationOptions getGenerationOptions() {
        return this.generationOptions;
    }

    @Override
    public void setGenerationOptions(GenerationOptions generationOptions) {
        this.generationOptions = generationOptions;
    }

    private String getPersistenceVersion() {
        ClassPath cp = this.workingCopy.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
        FileObject javaxEntityManagerFo = cp == null ? null : cp.findResource("javax/persistence/EntityManager.class");
        FileObject jakartaEntityManagerFo = cp == null ? null : cp.findResource("jakarta/persistence/EntityManager.class");
        String version = jakartaEntityManagerFo != null || javaxEntityManagerFo == null ? "3.0" : "1.0";
        if (this.persistenceUnit instanceof PersistenceUnit) {
            version = "3.2";
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit) {
            version = "3.1";
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit) {
            version = "3.0";
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit) {
            version = "2.2";
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit) {
            version = "2.1";
        } else if (this.persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit) {
            version = "2.0";
        }
        return version;
    }

    protected String getEntityManagerFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return ENTITY_MANAGER_FQN;
            }
        }
        return ENTITY_MANAGER_JAKARTA_FQN;
    }

    protected String getEntityManagerFactoryFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return ENTITY_MANAGER_FACTORY_FQN;
            }
        }
        return ENTITY_MANAGER_FACTORY_JAKARTA_FQN;
    }

    protected String getUserTxFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return USER_TX_FQN;
            }
        }
        return USER_TX_JAKARTA_FQN;
    }

    protected String getPersistenceContextFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return PERSISTENCE_CONTEXT_FQN;
            }
        }
        return PERSISTENCE_CONTEXT_JAKARTA_FQN;
    }

    protected String getPersistenceUnitFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return PERSISTENCE_UNIT_FQN;
            }
        }
        return PERSISTENCE_UNIT_JAKARTA_FQN;
    }

    protected String getPostConstructFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return POST_CONSTRUCT_FQN;
            }
        }
        return POST_CONSTRUCT_JAKARTA_FQN;
    }

    protected String getPreDestroyFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return PRE_DESTROY_FQN;
            }
        }
        return PRE_DESTROY_JAKARTA_FQN;
    }

    protected String getResourceFqn() {
        String version;
        switch (version = this.getPersistenceVersion()) {
            case "1.0": 
            case "2.0": 
            case "2.1": 
            case "2.2": {
                return RESOURCE_FQN;
            }
        }
        return RESOURCE_JAKARTA_FQN;
    }

    protected static class FieldInfo {
        private String name;
        private boolean existing;

        FieldInfo(String name, boolean existing) {
            this.name = name;
            this.existing = existing;
        }

        public String getName() {
            return this.name;
        }

        public boolean isExisting() {
            return this.existing;
        }
    }

    protected static enum Initialization {
        INJECT,
        EMF,
        INIT;

    }
}

