/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.CancelSupportImplementation;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.SchedulerTaskCancelSupportImpl;
import org.netbeans.modules.csl.core.SpiSupportAccessor;
import org.netbeans.modules.csl.editor.semantic.GsfSemanticLayer;
import org.netbeans.modules.csl.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.csl.editor.semantic.SequenceElement;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class MarkOccurrencesHighlighter
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(MarkOccurrencesHighlighter.class.getName());
    private final CancelSupportImplementation cancel = SchedulerTaskCancelSupportImpl.create((SchedulerTask)this);
    private final Language language;
    private final Snapshot snapshot;
    static final ColoringAttributes.Coloring MO = ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.MARK_OCCURRENCES);
    public static final Color ES_COLOR = new Color(175, 172, 102);

    MarkOccurrencesHighlighter(Language language, Snapshot snapshot) {
        this.language = language;
        this.snapshot = snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ParserResult info, SchedulerEvent event) {
        SpiSupportAccessor.getInstance().setCancelSupport(this.cancel);
        try {
            Document doc = this.snapshot.getSource().getDocument(false);
            if (doc == null) {
                LOG.log(Level.INFO, "MarkOccurencesHighlighter: Cannot get document!");
                return;
            }
            if (!(event instanceof CursorMovedSchedulerEvent)) {
                return;
            }
            int caretPosition = ((CursorMovedSchedulerEvent)event).getCaretOffset();
            if (this.cancel.isCancelled()) {
                return;
            }
            int snapshotOffset = info.getSnapshot().getEmbeddedOffset(caretPosition);
            if (snapshotOffset == -1) {
                return;
            }
            List<Object> bag = Collections.emptyList();
            if (snapshotOffset >= 0) {
                bag = this.processImpl(info, doc, caretPosition);
            }
            GsfSemanticLayer layer = GsfSemanticLayer.getLayer(MarkOccurrencesHighlighter.class, doc);
            TreeSet<SequenceElement> seqs = new TreeSet<SequenceElement>(SequenceElement.POSITION_ORDER);
            for (OffsetRange offsetRange : bag) {
                if (offsetRange == OffsetRange.NONE) continue;
                try {
                    seqs.add(new SequenceElement(this.language, doc.createPosition(offsetRange.getStart()), doc.createPosition(offsetRange.getEnd()), MO));
                }
                catch (BadLocationException badLocationException) {}
            }
            boolean updateHighlights = false;
            if (seqs.isEmpty()) {
                OccurrencesFinder occurrencesFinder = this.language.getOccurrencesFinder();
                if (occurrencesFinder == null || !occurrencesFinder.isMarkOccurrencesEnabled() || !occurrencesFinder.isKeepMarks()) {
                    updateHighlights = true;
                }
            } else {
                updateHighlights = true;
            }
            if (updateHighlights) {
                layer.setColorings(seqs);
                OccurrencesMarkProvider.get(doc).setOccurrences(OccurrencesMarkProvider.createMarks(doc, bag, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
            }
        }
        finally {
            SpiSupportAccessor.getInstance().removeCancelSupport(this.cancel);
        }
    }

    @NonNull
    List<OffsetRange> processImpl(ParserResult info, Document doc, int caretPosition) {
        Map<Object, ColoringAttributes> highlights;
        OccurrencesFinder finder = this.language.getOccurrencesFinder();
        if (finder == null || !finder.isMarkOccurrencesEnabled()) {
            return List.of();
        }
        finder.setCaretPosition(caretPosition);
        try {
            finder.run((Parser.Result)info, null);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        if (this.cancel.isCancelled()) {
            finder.cancel();
        }
        if ((highlights = finder.getOccurrences()) == null) {
            LOG.log(Level.WARNING, "org.netbeans.modules.csl.api.OccurrencesFinder.getOccurrences() non-null contract violation by {0}", this.language.getMimeType());
            highlights = Map.of();
        }
        return List.copyOf(highlights.keySet());
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public final void cancel() {
    }

    public static AbstractHighlightsContainer getHighlightsBag(Document doc) {
        GsfSemanticLayer highlight = GsfSemanticLayer.getLayer(MarkOccurrencesHighlighter.class, doc);
        return highlight;
    }
}

