/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.Trees;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;

class ClassScanner
extends ErrorAwareTreePathScanner<TypeElement, Void> {
    private Trees trees;
    private Elements elements;
    private String binaryClassName;
    private String[] classExcludeNames;

    public ClassScanner(Trees trees, Elements elements, String binaryClassName, String[] classExcludeNames) {
        this.trees = trees;
        this.elements = elements;
        this.binaryClassName = binaryClassName;
        this.classExcludeNames = classExcludeNames;
    }

    public TypeElement reduce(TypeElement arg0, TypeElement arg1) {
        if (arg0 != null) {
            return arg0;
        }
        return arg1;
    }

    public TypeElement visitClass(ClassTree arg0, Void arg1) {
        TypeElement typeElement = (TypeElement)this.trees.getElement(this.getCurrentPath());
        if (typeElement == null) {
            return (TypeElement)super.visitClass(arg0, (Object)arg1);
        }
        String binaryName = this.elements.getBinaryName(typeElement).toString();
        if (this.match(binaryName)) {
            return typeElement;
        }
        return (TypeElement)super.visitClass(arg0, (Object)arg1);
    }

    private boolean match(String binaryName) {
        if (ClassScanner.match(binaryName, this.binaryClassName)) {
            if (this.classExcludeNames != null) {
                for (String classExcludeName : this.classExcludeNames) {
                    if (!ClassScanner.match(binaryName, classExcludeName)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean match(String name, String pattern) {
        if (pattern.startsWith("*")) {
            return name.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return name.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return name.equals(pattern);
    }
}

