/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui;

import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.netbeans.modules.web.browser.api.ResizeOption;
import org.openide.util.ImageUtilities;

class BrowserResizeButton
extends JToggleButton {
    private final ResizeOption resizeOption;
    private static final String ICON_PATH_PREFIX = "org/netbeans/modules/web/browser/ui/resources/";

    private BrowserResizeButton(ResizeOption resizeOption) {
        this.resizeOption = resizeOption;
        this.setIcon(BrowserResizeButton.toIcon(resizeOption));
        this.setToolTipText(resizeOption.getToolTip());
    }

    ResizeOption getResizeOption() {
        return this.resizeOption;
    }

    static BrowserResizeButton create(ResizeOption resizeOption) {
        return new BrowserResizeButton(resizeOption);
    }

    static Icon toIcon(ResizeOption ro) {
        if (ro == ResizeOption.SIZE_TO_FIT) {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/sizeToFit.png", (boolean)true);
        }
        return BrowserResizeButton.toIcon(ro.getType());
    }

    static Icon toIcon(ResizeOption.Type type) {
        switch (type) {
            case NETBOOK: {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/netbook.png", (boolean)true);
            }
            case SMARTPHONE_LANDSCAPE: {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/handheldLandscape.png", (boolean)true);
            }
            case SMARTPHONE_PORTRAIT: {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/handheldPortrait.png", (boolean)true);
            }
            case TABLET_LANDSCAPE: {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/tabletLandscape.png", (boolean)true);
            }
            case TABLET_PORTRAIT: {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/tabletPortrait.png", (boolean)true);
            }
            case WIDESCREEN: {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/widescreen.png", (boolean)true);
            }
        }
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/desktop.png", (boolean)true);
    }
}

