/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.samples.wizard.iterator;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.client.samples.wizard.iterator.AbstractWizardIterator;
import org.netbeans.modules.web.client.samples.wizard.iterator.Bundle;
import org.netbeans.modules.web.client.samples.wizard.iterator.OnlineSiteTemplate;
import org.netbeans.modules.web.client.samples.wizard.ui.OnlineSamplePanel;
import org.netbeans.modules.web.clientproject.createprojectapi.ClientSideProjectGenerator;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class OnlineSampleWizardIterator
extends AbstractWizardIterator {
    private static final String LIBRARIES_PATH = "LIBRARIES_PATH";

    protected OnlineSampleWizardIterator() {
    }

    protected abstract OnlineSiteTemplate getSiteTemplate();

    protected abstract String getProjectName();

    protected abstract String getProjectZipURL();

    @Override
    protected WizardDescriptor.Panel[] createPanels(WizardDescriptor wizard) {
        wizard.putProperty("sampleProjectName", (Object)this.getProjectName());
        wizard.putProperty("sampleProjectURL", (Object)this.getProjectZipURL());
        wizard.putProperty("sampleTemplate", (Object)this.getSiteTemplate());
        return new WizardDescriptor.Panel[]{new OnlineSamplePanel(wizard)};
    }

    @Override
    public Set instantiate(ProgressHandle handle) throws IOException {
        File parent;
        FileObject startFileFo;
        handle.start();
        handle.progress(Bundle.OnlineSampleWizardIterator_creatingProject());
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        File projectDir = FileUtil.normalizeFile((File)((File)this.descriptor.getProperty("sampleProjectDir")));
        String name = (String)this.descriptor.getProperty("sampleProjectName");
        if (!projectDir.isDirectory() && !projectDir.mkdirs()) {
            throw new IOException("Cannot create project directory");
        }
        FileObject projectDirFO = FileUtil.toFileObject((File)projectDir);
        CreateProjectProperties props = new CreateProjectProperties(projectDirFO, name).setStartFile("index.html");
        OnlineSiteTemplate siteTemplate = this.getSiteTemplate();
        if (siteTemplate != null) {
            siteTemplate.configure(props);
        }
        Project project = ClientSideProjectGenerator.createProject((CreateProjectProperties)props);
        files.add(projectDirFO);
        if (siteTemplate != null) {
            handle.progress(Bundle.OnlineSampleWizardIterator_applyingTemplate());
            this.applySiteTemplate(project.getProjectDirectory(), props, siteTemplate, handle);
        }
        FileObject siteRoot = project.getProjectDirectory().getFileObject(props.getSiteRootFolder());
        assert (siteRoot != null);
        String startFile = props.getStartFile();
        if (startFile != null && (startFileFo = siteRoot.getFileObject(startFile)) != null) {
            files.add(startFileFo);
        }
        if ((parent = projectDir.getParentFile()) != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        handle.finish();
        return files;
    }

    private void applySiteTemplate(FileObject projectDir, CreateProjectProperties props, OnlineSiteTemplate siteTemplate, ProgressHandle handle) {
        assert (!EventQueue.isDispatchThread());
        String templateName = siteTemplate.getName();
        try {
            siteTemplate.apply(projectDir, props, handle);
        }
        catch (IOException ex) {
            this.errorOccured(Bundle.OnlineSampleWizardIterator_error_applyingSiteTemplate(templateName));
        }
    }

    private void errorOccured(String message) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }
}

