/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.util.Random;
import org.netbeans.modules.debugger.jpda.expr.CompilationInfoHolder;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;

public class JavaExpression {
    public static final String LANGUAGE_JAVA_1_5 = "1.5.0";
    private static final String REPLACE_return = "return01234";
    private static final String REPLACE_class = "class01234";
    static final String RETURN_MACRO = "{return}";
    static final String CLASS_MACRO = "{class}";
    private String strExpression;
    private String language;
    private String replace_return;
    private String replace_class;

    public static JavaExpression parse(String expr, String language) {
        Object replace_return = REPLACE_return;
        while (expr.indexOf((String)replace_return) >= 0) {
            replace_return = "return" + new Random().nextLong();
        }
        Object replace_class = REPLACE_class;
        while (expr.indexOf((String)replace_class) >= 0) {
            replace_class = "class" + new Random().nextLong();
        }
        String replacedExpr = JavaExpression.replaceSpecialVar(expr, RETURN_MACRO, (String)replace_return);
        replacedExpr = JavaExpression.replaceSpecialVar(replacedExpr, CLASS_MACRO, (String)replace_class);
        return new JavaExpression(replacedExpr, language, (String)replace_return, (String)replace_class);
    }

    private static String replaceSpecialVar(String expr, String var, String replace_var) {
        int i = ((String)expr).indexOf(var);
        while (i >= 0) {
            char ch;
            boolean replace = i > 0 ? !Character.isJavaIdentifierStart(ch = ((String)expr).charAt(i - 1)) && !Character.isJavaIdentifierPart(ch) && ch != '.' : true;
            if (replace && i < ((String)expr).length() - var.length() && Character.isJavaIdentifierPart(ch = ((String)expr).charAt(i + var.length()))) {
                replace = false;
            }
            if (replace) {
                expr = ((String)expr).substring(0, i) + replace_var + ((String)expr).substring(i + var.length());
                i += replace_var.length();
            } else {
                i += var.length();
            }
            i = ((String)expr).indexOf(var, i);
        }
        return expr;
    }

    private JavaExpression(String expression, String language, String replace_return, String replace_class) {
        this.strExpression = expression;
        this.language = language;
        this.replace_return = replace_return;
        this.replace_class = replace_class;
    }

    public TreeEvaluator evaluator(EvaluationContext context, CompilationInfoHolder ciHolder) {
        return new TreeEvaluator(this, context, ciHolder);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getExpression() {
        return this.strExpression;
    }

    String returnReplaced() {
        return this.replace_return;
    }

    String classReplaced() {
        return this.replace_class;
    }
}

