/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import com.google.gson.Gson;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.openjdk.project.ConfigurationImpl;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CProjectConfigurationProviderImpl
implements InvocationHandler {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final JDKProject project;
    private final Constructor<?> newProjectConfiguration;
    private static final Logger LOG = Logger.getLogger(CProjectConfigurationProviderImpl.class.getName());

    public static Object create(JDKProject project) {
        try {
            ClassLoader generalCL = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            ClassLoader thisCL = CProjectConfigurationProviderImpl.class.getClassLoader();
            if (generalCL == null) {
                generalCL = thisCL;
            }
            Class<?> provider = generalCL.loadClass("org.netbeans.modules.cpplite.editor.spi.CProjectConfigurationProvider");
            Class<?> projectConfiguration = generalCL.loadClass("org.netbeans.modules.cpplite.editor.spi.CProjectConfigurationProvider$ProjectConfiguration");
            Constructor<?> newProjectConfiguration = projectConfiguration.getDeclaredConstructor(String.class, Boolean.TYPE);
            return Proxy.newProxyInstance(generalCL, new Class[]{provider}, (InvocationHandler)new CProjectConfigurationProviderImpl(project, newProjectConfiguration));
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            return "none";
        }
    }

    public CProjectConfigurationProviderImpl(JDKProject project, Constructor<?> newProjectConfiguration) {
        this.project = project;
        this.newProjectConfiguration = newProjectConfiguration;
        ConfigurationImpl.getProvider(project.moduleRepository.getJDKRoot()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || "activeConfiguration".equals(evt.getPropertyName())) {
                    CProjectConfigurationProviderImpl.this.cs.fireChange();
                }
            }
        });
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getProjectConfiguration": {
                return this.newProjectConfiguration.newInstance(this.configuration(this.project), true);
            }
            case "addChangeListener": {
                this.cs.addChangeListener((ChangeListener)args[0]);
                return null;
            }
            case "removeChangeListener": {
                this.cs.removeChangeListener((ChangeListener)args[0]);
                return null;
            }
        }
        throw new UnsupportedOperationException("Not supported yet: " + method.getName());
    }

    private String configuration(JDKProject project) {
        HashSet<String> sourceFiles = new HashSet<String>();
        for (JDKProject.Root root : project.getRoots()) {
            URL location;
            FileObject rootFO;
            if (root.kind != JDKProject.RootKind.NATIVE_SOURCES || (rootFO = URLMapper.findFileObject((URL)(location = root.getLocation()))) == null) continue;
            Enumeration children = rootFO.getChildren(true);
            while (children.hasMoreElements()) {
                FileObject child = (FileObject)children.nextElement();
                if (!child.isData() || child.getExt().equalsIgnoreCase("h") || child.getExt().equalsIgnoreCase("hh")) continue;
                sourceFiles.add(FileUtil.toFile((FileObject)child).getAbsolutePath());
            }
        }
        if (sourceFiles.isEmpty()) {
            return null;
        }
        ConfigurationImpl activeConfig = ConfigurationImpl.getProvider(project.moduleRepository.getJDKRoot()).getActiveConfiguration();
        if (activeConfig != null) {
            List commands;
            File buildDir = activeConfig.getLocation();
            File spec = new File(buildDir, "spec.gmk");
            File compileCommands = new File(buildDir, "compile_commands.json");
            if (!compileCommands.canRead() || compileCommands.lastModified() < spec.lastModified()) {
                try {
                    new ProcessBuilder("make", "compile_commands").inheritIO().start().waitFor();
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                    return null;
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
            if (!compileCommands.canRead()) {
                return null;
            }
            try (BufferedReader r = Files.newBufferedReader(compileCommands.toPath());){
                commands = (List)new Gson().fromJson((Reader)r, ArrayList.class);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            Iterator it = commands.iterator();
            while (it.hasNext()) {
                Map fileDescription = (Map)it.next();
                if (sourceFiles.contains(fileDescription.get("file"))) continue;
                it.remove();
            }
            if (commands.isEmpty()) {
                return null;
            }
            return new Gson().toJson((Object)commands);
        }
        return null;
    }
}

