/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class FreeformEvaluator
implements PropertyEvaluator,
AntProjectListener,
PropertyChangeListener {
    private final FreeformProject project;
    private PropertyEvaluator delegate;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Set<PropertyEvaluator> intermediateEvaluators = new HashSet<PropertyEvaluator>();
    private final Object privateLock = new Object();

    public FreeformEvaluator(FreeformProject project) throws IOException {
        this.project = project;
        this.init();
        project.helper().addAntProjectListener((AntProjectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        PropertyEvaluator newDelegate = this.initEval();
        Object object = this.privateLock;
        synchronized (object) {
            if (this.delegate != null) {
                this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
            }
            newDelegate.addPropertyChangeListener((PropertyChangeListener)this);
            this.delegate = newDelegate;
        }
        if (Util.err.isLoggable(1)) {
            Util.err.log("properties for " + this.project.getProjectDirectory() + ": " + this.delegate.getProperties());
        }
    }

    private PropertyEvaluator initEval() throws IOException {
        Iterator<PropertyEvaluator> ieIt = this.intermediateEvaluators.iterator();
        while (ieIt.hasNext()) {
            ieIt.next().removePropertyChangeListener((PropertyChangeListener)this);
            ieIt.remove();
        }
        PropertyProvider preprovider = this.project.helper().getStockPropertyPreprovider();
        ArrayList<PropertyProvider> defs = new ArrayList<PropertyProvider>();
        Element genldata = this.project.getPrimaryConfigurationData();
        Element properties = XMLUtil.findElement((Element)genldata, (String)"properties", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (properties != null) {
            for (Element e : XMLUtil.findSubElements((Element)properties)) {
                if (e.getLocalName().equals("property")) {
                    String val = XMLUtil.findText((Node)e);
                    if (val == null) {
                        val = "";
                    }
                    defs.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap(e.getAttribute("name"), val)));
                    continue;
                }
                assert (e.getLocalName().equals("property-file")) : e;
                String fname = XMLUtil.findText((Node)e);
                if (fname.contains("${")) {
                    PropertyEvaluator intermediate = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)preprovider, (PropertyProvider[])defs.toArray(new PropertyProvider[0]));
                    fname = intermediate.evaluate(fname);
                    if (fname == null) continue;
                    intermediate.addPropertyChangeListener((PropertyChangeListener)this);
                    this.intermediateEvaluators.add(intermediate);
                }
                defs.add(PropertyUtils.propertiesFilePropertyProvider((File)this.project.helper().resolveFile(fname)));
            }
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)preprovider, (PropertyProvider[])defs.toArray(new PropertyProvider[0]));
    }

    public String getProperty(String prop) {
        return this.delegate.getProperty(prop);
    }

    public String evaluate(String text) {
        return this.delegate.evaluate(text);
    }

    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.pcs.removePropertyChangeListener(listener);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.fireAnyChange();
    }

    private void fireAnyChange() {
        try {
            this.init();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object source = propertyChangeEvent.getSource();
        assert (source instanceof PropertyEvaluator) : source;
        if (this.intermediateEvaluators.contains(source)) {
            this.fireAnyChange();
        } else {
            assert (source == this.delegate) : "Got change from " + source + " rather than current delegate " + this.delegate;
            this.pcs.firePropertyChange(propertyChangeEvent.getPropertyName(), null, null);
        }
    }
}

