/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ui.wizard;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.util.TomcatUsers;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class InstallPanelVisual
extends JPanel {
    private static final String SERVER_XML = "conf/server.xml";
    private static final Logger LOGGER = Logger.getLogger(InstallPanelVisual.class.getName());
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String errorMessage;
    private boolean infoMessage;
    private String serverPort;
    private String shutdownPort;
    private String serverHeader;
    private RequestProcessor.Task validationTask;
    private String textHomeDir;
    private TomcatManager.TomcatVersion version;
    private JCheckBox createUserCheckBox;
    private JButton jButtonBaseBrowse;
    private JButton jButtonHomeBrowse;
    private JCheckBox jCheckBoxShared;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelBaseDir;
    private JLabel jLabelHomeDir;
    private JLabel jLabelPassword;
    private JLabel jLabelUsername;
    private JTextField jTextFieldBaseDir;
    private JTextField jTextFieldHomeDir;
    private JPasswordField jTextFieldPassword;
    private JTextField jTextFieldUsername;

    public InstallPanelVisual() {
        this.initComponents();
        DocumentListener updateListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }
        };
        this.jTextFieldHomeDir.getDocument().addDocumentListener(updateListener);
        this.jTextFieldBaseDir.getDocument().addDocumentListener(updateListener);
        this.jTextFieldUsername.getDocument().addDocumentListener(updateListener);
        this.jTextFieldPassword.getDocument().addDocumentListener(updateListener);
        this.createUserCheckBox.getModel().addItemListener(e -> this.fireChange());
        this.addChangeListener(e -> {
            if (this.isJWSDP()) {
                if (this.jCheckBoxShared.isEnabled()) {
                    this.jCheckBoxShared.setEnabled(false);
                    this.setBaseEnabled(false);
                }
            } else if (!this.jCheckBoxShared.isEnabled()) {
                this.jCheckBoxShared.setEnabled(true);
                if (this.jCheckBoxShared.isSelected()) {
                    this.setBaseEnabled(true);
                }
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void initComponents() {
        this.jLabelHomeDir = new JLabel();
        this.jLabelBaseDir = new JLabel();
        this.jTextFieldHomeDir = new JTextField();
        this.jTextFieldBaseDir = new JTextField();
        this.jButtonBaseBrowse = new JButton();
        this.jButtonHomeBrowse = new JButton();
        this.jCheckBoxShared = new JCheckBox();
        this.jLabelUsername = new JLabel();
        this.jLabelPassword = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextFieldPassword = new JPasswordField();
        this.jTextFieldUsername = new JTextField();
        this.jLabel2 = new JLabel();
        this.createUserCheckBox = new JCheckBox();
        this.setName(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_InstallationAndLoginDetails"));
        this.jLabelHomeDir.setLabelFor(this.jTextFieldHomeDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelHomeDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_home_dir"));
        this.jLabelBaseDir.setLabelFor(this.jTextFieldBaseDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelBaseDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_base_dir"));
        this.jLabelBaseDir.setEnabled(false);
        this.jTextFieldHomeDir.setColumns(15);
        this.jTextFieldBaseDir.setColumns(15);
        this.jTextFieldBaseDir.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBaseBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_base"));
        this.jButtonBaseBrowse.setEnabled(false);
        this.jButtonBaseBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jButtonBaseBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonHomeBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_home"));
        this.jButtonHomeBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jButtonHomeBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxShared, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_SharedInstall"));
        this.jCheckBoxShared.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jCheckBoxSharedActionPerformed(evt);
            }
        });
        this.jLabelUsername.setLabelFor(this.jTextFieldUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabelUsername, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Username"));
        this.jLabelUsername.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.jLabelPassword.setLabelFor(this.jTextFieldPassword);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPassword, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Password"));
        this.jLabelPassword.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_TextAbove"));
        this.jTextFieldPassword.setColumns(20);
        this.jTextFieldUsername.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Credentials"));
        this.jLabel2.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.createUserCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createUserCheckBox, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUser"));
        this.createUserCheckBox.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.createUserCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createUserCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jCheckBoxShared).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelUsername).addComponent(this.jLabelPassword).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabelBaseDir)).addComponent(this.jLabelHomeDir)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createUserCheckBox).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldBaseDir, GroupLayout.Alignment.TRAILING, -1, 347, Short.MAX_VALUE).addComponent(this.jTextFieldHomeDir, GroupLayout.Alignment.TRAILING, -1, 347, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonHomeBrowse, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonBaseBrowse, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldPassword, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jTextFieldUsername, GroupLayout.Alignment.LEADING, -1, 129, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelHomeDir)).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHomeBrowse).addComponent(this.jTextFieldHomeDir, -2, -1, -2)))).addGap(5, 5, 5).addComponent(this.jCheckBoxShared).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelBaseDir)).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldBaseDir, -2, -1, -2).addComponent(this.jButtonBaseBrowse)))).addGap(14, 14, 14).addComponent(this.jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jLabelUsername)).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jTextFieldUsername, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelPassword).addComponent(this.jTextFieldPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createUserCheckBox).addContainerGap(51, Short.MAX_VALUE)));
        this.jLabelHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelHomeDir"));
        this.jLabelHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelHomeDir"));
        this.jLabelBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelBaseDir"));
        this.jLabelBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelBaseDir"));
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_homeDir"));
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_homeDir"));
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_baseDir"));
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_baseDir"));
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonBaseBrowse"));
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonBaseBrowse"));
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonHomeBrowse"));
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonHomeBrowse"));
        this.jCheckBoxShared.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_shared"));
        this.jCheckBoxShared.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_shared"));
        this.jLabelUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelUsername"));
        this.jLabelUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelUsername"));
        this.jLabelPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelPassword"));
        this.jLabelPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelPassword"));
        this.jTextFieldPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_password"));
        this.jTextFieldPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_password"));
        this.jTextFieldUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_username"));
        this.jTextFieldUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_username"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_panel"));
    }

    private void jButtonBaseBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(this.jTextFieldBaseDir.getText().trim()));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.jTextFieldBaseDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jButtonHomeBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(this.jTextFieldHomeDir.getText().trim()));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.jTextFieldHomeDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jCheckBoxSharedActionPerformed(ActionEvent evt) {
        this.setBaseEnabled(this.jCheckBoxShared.isSelected());
        this.fireChange();
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.put("httpportnumber", this.serverPort);
        p.put("admin_port", this.shutdownPort);
        p.put("monitor_enabled", "false");
        if (this.serverHeader != null) {
            p.put("server_header", this.serverHeader);
        }
        return p;
    }

    public synchronized TomcatManager.TomcatVersion getTomcatVersion() {
        return this.version;
    }

    public String getUrl() {
        String url;
        switch (this.getTomcatVersion()) {
            case TOMCAT_110: {
                url = "tomcat110:";
                break;
            }
            case TOMCAT_101: {
                url = "tomcat101:";
                break;
            }
            case TOMCAT_100: {
                url = "tomcat100:";
                break;
            }
            case TOMCAT_90: {
                url = "tomcat90:";
                break;
            }
            case TOMCAT_80: {
                url = "tomcat80:";
                break;
            }
            case TOMCAT_70: {
                url = "tomcat70:";
                break;
            }
            case TOMCAT_60: {
                url = "tomcat60:";
                break;
            }
            case TOMCAT_55: {
                url = "tomcat55:";
                break;
            }
            default: {
                url = "tomcat:";
            }
        }
        url = url + "home=" + this.jTextFieldHomeDir.getText();
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            url = url + ":base=" + this.jTextFieldBaseDir.getText();
        }
        Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.FINE, "TomcatInstall.getUrl: {0}", url);
        return url;
    }

    public String getUsername() {
        return this.jTextFieldUsername.getText();
    }

    public String getPassword() {
        return new String(this.jTextFieldPassword.getPassword());
    }

    boolean createUserEnabled() {
        return this.createUserCheckBox.isSelected();
    }

    public File getHomeDir() {
        return new File(this.jTextFieldHomeDir.getText());
    }

    private File getBaseDir() {
        File[] files;
        File base;
        if (this.jCheckBoxShared.isSelected() && (base = new File(this.jTextFieldBaseDir.getText())).isDirectory() && (files = base.listFiles()) != null && files.length > 0) {
            return base;
        }
        return new File(this.jTextFieldHomeDir.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : "<html>" + this.errorMessage.replace("<", "&lt;").replace(">", "&gt;") + "</html>";
    }

    public boolean isInfoMessage() {
        return this.infoMessage;
    }

    boolean isServerXmlValid(File file) {
        try {
            Server server = Server.createGraph(file);
            this.serverPort = TomcatInstallUtil.getPort(server);
            this.shutdownPort = TomcatInstallUtil.getShutdownPort(server);
            this.serverHeader = TomcatInstallUtil.getServerHeader(server);
            if (this.serverPort != null && this.shutdownPort != null) {
                Integer.parseInt(this.serverPort);
                Integer.parseInt(this.shutdownPort);
                return true;
            }
        }
        catch (IOException | RuntimeException ex) {
            Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.INFO, null, ex);
        }
        return false;
    }

    private boolean isHomeValid() {
        File serverFile;
        String base;
        File libDir;
        String homeDir = this.jTextFieldHomeDir.getText();
        if (homeDir.length() == 0) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyHomeDir");
            this.infoMessage = true;
            return false;
        }
        if (!new File(homeDir, "bin/bootstrap.jar").exists()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidHomeDir");
            return false;
        }
        File file = libDir = TomcatManager.TomcatVersion.TOMCAT_50.equals((Object)this.getTomcatVersion()) || TomcatManager.TomcatVersion.TOMCAT_55.equals((Object)this.getTomcatVersion()) ? new File(homeDir, "common" + File.separator + "lib") : new File(homeDir, "lib");
        if (!libDir.exists() || !libDir.isDirectory()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidHomeDir");
            return false;
        }
        boolean serverXmlInBaseDir = false;
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() && (base = this.jTextFieldBaseDir.getText()).length() != 0 && (serverFile = new File(base, SERVER_XML)).exists()) {
            serverXmlInBaseDir = true;
        }
        File serverFile2 = new File(homeDir, SERVER_XML);
        if (!serverXmlInBaseDir && !serverFile2.canRead()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableHomeServerXml");
            return false;
        }
        if (!(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() || this.isServerXmlValid(serverFile2))) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
            return false;
        }
        return true;
    }

    private boolean isJWSDP() {
        File homeDir;
        if (this.isHomeValid() && (homeDir = this.getHomeDir()) != null && homeDir.exists()) {
            File[] files = homeDir.listFiles((dir, name) -> "jwsdp-shared".equals(name));
            return files.length != 0;
        }
        return false;
    }

    private boolean isBaseValid() {
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            String base = this.jTextFieldBaseDir.getText();
            if (base.length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyBaseDir");
                this.infoMessage = true;
                return false;
            }
            File baseDir = new File(base);
            String[] files = baseDir.list();
            File serverXml = new File(baseDir, SERVER_XML);
            if (!baseDir.exists() || files == null || files.length > 0 && !serverXml.exists()) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidBaseDir");
                return false;
            }
            if (files.length > 0) {
                if (!serverXml.canRead()) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableBaseServerXml");
                    return false;
                }
                if (!this.isServerXmlValid(serverXml)) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedBaseServerXml");
                    return false;
                }
            } else {
                File serverFile = new File(this.jTextFieldHomeDir.getText(), SERVER_XML);
                if (!serverFile.canRead()) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableHomeServerXml");
                    return false;
                }
                if (!this.isServerXmlValid(serverFile)) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isUsernamePasswordValid() {
        if (this.createUserCheckBox.isSelected()) {
            if (this.jTextFieldUsername.getText().length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UsernameEmpty");
                this.infoMessage = true;
                return false;
            }
            if (this.jTextFieldPassword.getPassword().length == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_PasswordEmpty");
                this.infoMessage = true;
                return false;
            }
        } else {
            if (this.jTextFieldUsername.getText().length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UsernameEmptyWarning");
                this.infoMessage = true;
            }
            File tomcatUsersXml = new File(this.getBaseDir(), "conf/tomcat-users.xml");
            try {
                if (!TomcatUsers.userExists(tomcatUsersXml, this.jTextFieldUsername.getText())) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UserDoesNotExist");
                    this.infoMessage = true;
                } else if (!TomcatUsers.hasManagerRole(this.getTomcatVersion(), tomcatUsersXml, this.jTextFieldUsername.getText())) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UserHasNotManagerRole", (Object)(this.getTomcatVersion().isAtLeast(TomcatManager.TomcatVersion.TOMCAT_70) ? "manager-script" : "manager"));
                    this.infoMessage = true;
                }
            }
            catch (IOException e) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_MissingOrInvalidTomcatUsersXml", (Object)tomcatUsersXml.getPath());
            }
        }
        return true;
    }

    private boolean isAlreadyRegistered() {
        if (InstanceProperties.getInstanceProperties((String)this.getUrl()) != null) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() ? "MSG_AlreadyRegisteredBase" : "MSG_AlreadyRegisteredHome"));
            return true;
        }
        return false;
    }

    private void setBaseEnabled(boolean enabled) {
        this.jLabelBaseDir.setEnabled(enabled);
        this.jTextFieldBaseDir.setEnabled(enabled);
        this.jButtonBaseBrowse.setEnabled(enabled);
    }

    public boolean hasValidData() {
        this.errorMessage = null;
        this.infoMessage = false;
        return this.isHomeValid() && this.isBaseValid() && !this.isAlreadyRegistered() && this.isUsernamePasswordValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        InstallPanelVisual installPanelVisual = this;
        synchronized (installPanelVisual) {
            this.textHomeDir = this.jTextFieldHomeDir.getText();
        }
        if (this.validationTask == null) {
            this.validationTask = RequestProcessor.getDefault().create(() -> {
                InstallPanelVisual installPanelVisual = this;
                synchronized (installPanelVisual) {
                    this.version = TomcatFactory.getTomcatVersion(new File(this.textHomeDir));
                    LOGGER.log(Level.FINE, "Detected Tomcat version {0}", (Object)this.version);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangeEvent event = new ChangeEvent(this);
                        for (ChangeListener listener : InstallPanelVisual.this.listeners) {
                            listener.stateChanged(event);
                        }
                    }
                });
            });
        }
        this.validationTask.schedule(60);
    }
}

