/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wseditor;

import java.awt.Dimension;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.wseditor.InvalidDataException;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class EditWSAttributesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private StringBuffer description;
    private TreeMap<String, WSEditor> treeMap;
    private JLabel descLabel;
    private JPanel jPanel1;
    private JTabbedPane jTabbedPane1;

    public EditWSAttributesPanel() {
        this.initComponents();
        this.initComponents();
        this.treeMap = new TreeMap(new AlphabeticalComparator());
        this.description = new StringBuffer("");
    }

    public void addTabs(Set<WSEditor> editors, Node node, JaxWsModel jaxWsModel) throws InvalidDataException {
        this.jTabbedPane1.removeAll();
        this.treeMap.clear();
        for (WSEditor wSEditor : editors) {
            this.treeMap.put(wSEditor.getTitle(), wSEditor);
        }
        Set<String> titles = this.treeMap.keySet();
        for (String title : titles) {
            WSEditor editor = this.treeMap.get(title);
            JComponent c = editor.createWSEditorComponent(node);
            if (c == null) continue;
            this.jTabbedPane1.addTab(title, c);
            String desc = editor.getDescription();
            if (desc == null || desc.trim().equals("")) continue;
            c.getAccessibleContext().setAccessibleDescription(desc);
            this.description.append(desc);
        }
        String string = this.description.toString();
        String helpText = NbBundle.getMessage(EditWSAttributesPanel.class, (String)"MSG_PRESS_F1");
        if (!string.equals("")) {
            String string2 = "<html>" + string + " " + helpText + " </html>";
            this.descLabel.setText(string2);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.descLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.descLabel.setLabelFor(this.jTabbedPane1);
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage(EditWSAttributesPanel.class, (String)"MSG_NO_EDITORS"));
        this.descLabel.setToolTipText(NbBundle.getMessage(EditWSAttributesPanel.class, (String)"HINT_EditWSAttributesTopComponent"));
        this.descLabel.setPreferredSize(new Dimension(261, 16));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.descLabel, -1, 601, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.descLabel, -1, 15, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, -1, 625, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 493, Short.MAX_VALUE)));
    }

    static class AlphabeticalComparator
    implements Comparator<String> {
        AlphabeticalComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            return str1.toLowerCase().compareTo(str2.toLowerCase());
        }
    }
}

