/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.editors2.CustomTableModelEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableModelEditor
implements PropertyEditor,
XMLPropertyEditor,
ExPropertyEditor,
NamedPropertyEditor {
    private static final String XML_TABLE = "Table";
    private static final String XML_COLUMN = "Column";
    private static final String XML_DATA = "Data";
    private static final String ATTR_COLUMN_COUNT = "columnCount";
    private static final String ATTR_ROW_COUNT = "rowCount";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_EDITABLE = "editable";
    private static final String ATTR_VALUE = "value";
    private NbTableModel table;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private PropertyEnv env;

    @Override
    public Object getValue() {
        return this.table;
    }

    @Override
    public void setValue(Object value) {
        this.table = new NbTableModel((TableModel)value);
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String string) {
    }

    @Override
    public String getJavaInitializationString() {
        TableModel m = (TableModel)this.getValue();
        StringBuilder titlesSB = new StringBuilder();
        int i = m.getColumnCount();
        int j = m.getRowCount();
        titlesSB.append("{\n\t\t");
        if (i > 0) {
            String s = m.getColumnName(0);
            s = s == null ? "" : s.replace("\"", "\\\"");
            titlesSB.append("\"").append(s).append('\"');
            for (int k = 1; k < i; ++k) {
                String s1 = m.getColumnName(k);
                s1 = s1 == null ? "" : s1.replace("\"", "\\\"");
                titlesSB.append(", \"").append(s1).append('\"');
            }
        }
        titlesSB.append("\n\t}");
        boolean generateTypes = false;
        StringBuilder typesSB = new StringBuilder();
        typesSB.append("{\n\t\t");
        if (i > 0) {
            typesSB.append(m.getColumnClass(0).getName()).append(".class");
            if (m.getColumnClass(0) != Object.class) {
                generateTypes = true;
            }
            for (int k = 1; k < i; ++k) {
                if (m.getColumnClass(k) != Object.class) {
                    generateTypes = true;
                }
                typesSB.append(", ").append(m.getColumnClass(k).getName()).append(".class");
            }
        }
        typesSB.append("\n\t}");
        boolean generateEditable = false;
        StringBuilder editableSB = new StringBuilder();
        editableSB.append("{\n\t\t");
        if (i > 0) {
            editableSB.append(m.isCellEditable(0, 0));
            if (!m.isCellEditable(0, 0)) {
                generateEditable = true;
            }
            for (int k = 1; k < i; ++k) {
                if (!m.isCellEditable(0, k)) {
                    generateEditable = true;
                }
                editableSB.append(", ").append(m.isCellEditable(0, k));
            }
        }
        editableSB.append("\n\t}");
        StringBuilder dataSB = new StringBuilder();
        dataSB.append("{\n\t\t");
        if (j > 0) {
            for (int l = 0; l < j; ++l) {
                if (l != 0) {
                    dataSB.append(",\n\t\t");
                }
                if (i == 0) {
                    dataSB.append("{}");
                    continue;
                }
                Object obj = m.getValueAt(l, 0);
                dataSB.append('{').append(TableModelEditor.getAsString(obj));
                for (int i1 = 1; i1 < i; ++i1) {
                    obj = m.getValueAt(l, i1);
                    dataSB.append(", ").append(TableModelEditor.getAsString(obj));
                }
                dataSB.append('}');
            }
        }
        dataSB.append("\n\t}");
        if (generateEditable || generateTypes) {
            return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + dataSB.toString() + ",\n\tnew String [] " + titlesSB.toString() + "\n) {\n" + (generateTypes ? "\tClass[] types = new Class [] " + typesSB.toString() + ";\n" : "") + (generateEditable ? "\tboolean[] canEdit = new boolean [] " + editableSB.toString() + ";\n" : "") + (generateTypes ? "\n\tpublic Class getColumnClass(int columnIndex) {\n\t\treturn types [columnIndex];\n\t}\n" : "") + (generateEditable ? "\n\tpublic boolean isCellEditable(int rowIndex, int columnIndex) {\n\t\treturn canEdit [columnIndex];\n\t}\n" : "") + "}";
        }
        return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + dataSB.toString() + ",\n\tnew String [] " + titlesSB.toString() + "\n)";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
        String msg = NbBundle.getMessage(TableModelEditor.class, (String)"MSG_TableModel");
        FontMetrics fm = g.getFontMetrics();
        g.drawString(msg, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new CustomTableModelEditor(this, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document doc) {
        Element tableEl = doc.createElement(XML_TABLE);
        int colCount = this.table.getColumnCount();
        int rowCount = this.table.getRowCount();
        tableEl.setAttribute(ATTR_COLUMN_COUNT, Integer.toString(colCount));
        tableEl.setAttribute(ATTR_ROW_COUNT, Integer.toString(rowCount));
        for (int i = 0; i < colCount; ++i) {
            int j;
            NbTableModel.ColumnItem column = this.table.getColumnItem(i);
            Element columnEl = doc.createElement(XML_COLUMN);
            columnEl.setAttribute(ATTR_TITLE, column.title);
            columnEl.setAttribute(ATTR_TYPE, column.type.getName());
            columnEl.setAttribute(ATTR_EDITABLE, column.editable ? "true" : "false");
            boolean anyData = false;
            for (j = 0; j < rowCount; ++j) {
                if (column.rows.get(j) == null) continue;
                anyData = true;
                break;
            }
            if (anyData) {
                for (j = 0; j < rowCount; ++j) {
                    Element dataEl = doc.createElement(XML_DATA);
                    dataEl.setAttribute(ATTR_VALUE, TableModelEditor.valueToString(column.rows.get(j)));
                    columnEl.appendChild(dataEl);
                }
            }
            tableEl.appendChild(columnEl);
        }
        return tableEl;
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_TABLE.equals(element.getNodeName())) {
            throw new IOException(TableModelEditor.getReadingErrorMessage());
        }
        NamedNodeMap tableAttr = element.getAttributes();
        if (tableAttr == null) {
            return;
        }
        IOException ioex = null;
        int columnCount = -1;
        int rowCount = -1;
        Node node = tableAttr.getNamedItem(ATTR_COLUMN_COUNT);
        if (node != null) {
            try {
                columnCount = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException e) {
                ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
            }
        }
        if ((node = tableAttr.getNamedItem(ATTR_ROW_COUNT)) != null) {
            try {
                rowCount = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException e) {
                if (ioex == null) {
                    ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                }
                ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
            }
        }
        if (columnCount < 0 || rowCount < 0) {
            if (ioex == null) {
                ioex = new IOException(TableModelEditor.getReadingErrorMessage());
            }
            throw ioex;
        }
        ArrayList<NbTableModel.ColumnItem> columns = new ArrayList<NbTableModel.ColumnItem>(columnCount);
        NodeList columnNodes = element.getChildNodes();
        int cCount = columnNodes.getLength();
        for (int i = 0; i < cCount; ++i) {
            NamedNodeMap columnAttr;
            Node cNode = columnNodes.item(i);
            if (!XML_COLUMN.equals(cNode.getNodeName()) || (columnAttr = cNode.getAttributes()) == null) continue;
            String title = null;
            Class<?> type = null;
            Boolean editable = null;
            node = columnAttr.getNamedItem(ATTR_TITLE);
            if (node != null) {
                title = node.getNodeValue();
            }
            if ((node = columnAttr.getNamedItem(ATTR_TYPE)) != null) {
                try {
                    type = Class.forName(node.getNodeValue());
                }
                catch (Exception e) {
                    ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                    ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
                }
            }
            if ((node = columnAttr.getNamedItem(ATTR_EDITABLE)) != null) {
                editable = Boolean.valueOf(node.getNodeValue());
            }
            if (title == null || type == null || editable == null) {
                if (ioex == null) {
                    ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                }
                throw ioex;
            }
            ArrayList<Object> columnData = new ArrayList<Object>(rowCount);
            NodeList dataNodes = cNode.getChildNodes();
            int dCount = dataNodes.getLength();
            for (int j = 0; j < dCount; ++j) {
                NamedNodeMap dataAttr;
                Node dNode = dataNodes.item(j);
                if (!XML_DATA.equals(dNode.getNodeName()) || (dataAttr = dNode.getAttributes()) == null) continue;
                Object value = null;
                node = dataAttr.getNamedItem(ATTR_VALUE);
                if (node != null) {
                    try {
                        value = TableModelEditor.stringToValue(node.getNodeValue(), type);
                    }
                    catch (IllegalArgumentException e) {
                        ioex = new IOException(TableModelEditor.getReadingErrorMessage());
                        ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)e);
                        throw ioex;
                    }
                }
                columnData.add(value);
            }
            if (columnData.size() != rowCount) {
                if (columnData.isEmpty()) {
                    for (int ii = 0; ii < rowCount; ++ii) {
                        columnData.add(null);
                    }
                } else {
                    throw new IOException(TableModelEditor.getReadingErrorMessage());
                }
            }
            columns.add(new NbTableModel.ColumnItem(title, type, (boolean)editable, columnData));
        }
        if (columns.size() != columnCount) {
            throw new IOException(TableModelEditor.getReadingErrorMessage());
        }
        this.table = new NbTableModel(columns, rowCount);
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle(TableModelEditor.class);
    }

    private static String getReadingErrorMessage() {
        return TableModelEditor.getBundle().getString("ERR_InvalidXMLFormat");
    }

    private static String valueToString(Object value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof Character) {
            return value.toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return "null";
        }
        return null;
    }

    private static Object stringToValue(String encoded, Class type) {
        if ("null".equals(encoded)) {
            return null;
        }
        if (type == Object.class) {
            return encoded;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.equals(type)) {
            return Integer.valueOf(encoded);
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.equals(type)) {
            return Short.valueOf(encoded);
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.equals(type)) {
            return Byte.valueOf(encoded);
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.equals(type)) {
            return Long.valueOf(encoded);
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.equals(type)) {
            return Float.valueOf(encoded);
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.equals(type)) {
            return Double.valueOf(encoded);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.equals(type)) {
            return Boolean.valueOf(encoded);
        }
        if (Character.class.isAssignableFrom(type) || Character.TYPE.equals(type)) {
            return Character.valueOf(encoded.charAt(0));
        }
        if (String.class.isAssignableFrom(type)) {
            return encoded;
        }
        throw new IllegalArgumentException();
    }

    static String getAsString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + ((String)o).replace("\"", "\\\"") + "\"";
        }
        String s = o.getClass().getName();
        int g = s.lastIndexOf(46);
        if (g >= 0) {
            s = s.substring(g + 1, s.length());
        }
        String cast = "";
        if (o instanceof Byte) {
            cast = "(byte) ";
        } else if (o instanceof Short) {
            cast = "(short) ";
        }
        if (s.equals("Double") || s.equals("Float")) {
            String os = o.toString();
            if (os.equals("Infinity")) {
                o = s + ".POSITIVE_INFINITY";
            } else if (os.equals("-Infinity")) {
                o = s + ".NEGATIVE_INFINITY";
            } else if (os.equals("NaN")) {
                o = s + ".NaN";
            }
        }
        return " new " + s + "(" + cast + o + ")";
    }

    static Object getDefaultValue(Class c) {
        return null;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getBundle(this.getClass()).getString("CTL_TableModelEditor_DisplayName");
    }

    public static class NbTableModel
    extends AbstractTableModel
    implements Externalizable {
        static final long serialVersionUID = -6843008677521167210L;
        List<ColumnItem> columns;
        int rowCount;
        transient boolean alwaysEditable = false;

        public NbTableModel() {
        }

        public NbTableModel(String[] titles, Class[] types, boolean[] editable) {
            this(titles, types, editable, 4);
        }

        public NbTableModel(String[] titles, Class[] types, boolean[] editable, int rowCount) {
            this.rowCount = rowCount;
            this.columns = new ArrayList<ColumnItem>(titles.length);
            for (int i = 0; i < titles.length; ++i) {
                this.columns.add(new ColumnItem(titles[i], types[i], editable[i], rowCount));
            }
        }

        public NbTableModel(TableModel createFrom) {
            ResourceBundle bundle = TableModelEditor.getBundle();
            if (createFrom == null) {
                this.rowCount = 4;
                this.columns = new ArrayList<ColumnItem>(20);
                for (int i = 0; i < 4; ++i) {
                    this.columns.add(new ColumnItem(bundle.getString("CTL_Title") + " " + Integer.toString(i + 1), Object.class, true, this.rowCount));
                }
            } else {
                this.rowCount = createFrom.getRowCount();
                int colCount = createFrom.getColumnCount();
                this.columns = new ArrayList<ColumnItem>(colCount);
                if (createFrom instanceof NbTableModel) {
                    NbTableModel model = (NbTableModel)createFrom;
                    for (int i = 0; i < colCount; ++i) {
                        ColumnItem ci = model.columns.get(i);
                        this.columns.add(new ColumnItem(ci));
                    }
                } else {
                    for (int i = 0; i < colCount; ++i) {
                        ColumnItem ci = new ColumnItem(createFrom.getColumnName(i), createFrom.getColumnClass(i), true, this.rowCount);
                        for (int j = 0; j < this.rowCount; ++j) {
                            ci.rows.set(j, createFrom.getValueAt(j, i));
                        }
                        this.columns.add(ci);
                    }
                }
            }
        }

        NbTableModel(List<ColumnItem> columns, int rowCount) {
            this.columns = columns;
            this.rowCount = rowCount;
        }

        public Class getColumnClass(int i) {
            ColumnItem ci = this.columns.get(i);
            return ci.type;
        }

        public void setColumnClass(int i, Class type) {
            ColumnItem ci = this.columns.get(i);
            ci.type = type;
        }

        @Override
        public String getColumnName(int i) {
            ColumnItem ci = this.columns.get(i);
            return ci.title;
        }

        public void setColumnName(int i, String title) {
            ColumnItem ci = this.columns.get(i);
            ci.title = title;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        public boolean isColumnEditable(int i) {
            ColumnItem ci = this.columns.get(i);
            return ci.editable;
        }

        @Override
        public boolean isCellEditable(int i, int j) {
            if (this.alwaysEditable) {
                return true;
            }
            ColumnItem ci = this.columns.get(j);
            return ci.editable;
        }

        public void setColumnEditable(int i, boolean editable) {
            ColumnItem ci = this.columns.get(i);
            ci.editable = editable;
        }

        @Override
        public Object getValueAt(int row, int column) {
            ColumnItem ci = this.columns.get(column);
            return ci.rows.get(row);
        }

        @Override
        public void setValueAt(Object obj, int row, int column) {
            ColumnItem ci = this.columns.get(column);
            ci.rows.set(row, obj);
            this.fireTableCellUpdated(row, column);
        }

        private ColumnItem getColumnItem(int i) {
            return this.columns.get(i);
        }

        void setRowCount(int newRowCount) {
            if (newRowCount == this.rowCount) {
                return;
            }
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                List<Object> rows = this.columns.get((int)i).rows;
                if (newRowCount > this.rowCount) {
                    for (int nr = newRowCount - this.rowCount; nr > 0; --nr) {
                        rows.add(null);
                    }
                    continue;
                }
                for (int rn = this.rowCount - newRowCount; rn > 0; --rn) {
                    rows.remove(newRowCount + rn - 1);
                }
            }
            int rc = this.rowCount;
            this.rowCount = newRowCount;
            if (newRowCount > rc) {
                this.fireTableRowsInserted(rc, newRowCount - 1);
            } else {
                this.fireTableRowsDeleted(newRowCount, rc - 1);
            }
        }

        public void addRow(int index) {
            if (index >= 0 && index <= this.rowCount) {
                int n = this.columns.size();
                for (int i = 0; i < n; ++i) {
                    this.columns.get((int)i).rows.add(index, null);
                }
                ++this.rowCount;
                this.fireTableRowsInserted(index, index);
            }
        }

        public void removeRow(int index) {
            if (index >= 0 && index < this.rowCount) {
                int n = this.columns.size();
                for (int i = 0; i < n; ++i) {
                    this.columns.get((int)i).rows.remove(index);
                }
                --this.rowCount;
                this.fireTableRowsDeleted(index, index);
            }
        }

        public void moveRow(int fromIndex, int toIndex) {
            if (this.columns.size() > 0 && fromIndex >= 0 && fromIndex < this.rowCount && toIndex >= 0 && toIndex < this.rowCount && fromIndex != toIndex) {
                int n = this.columns.size();
                for (int i = 0; i < n; ++i) {
                    List<Object> rows = this.columns.get((int)i).rows;
                    Object obj = rows.get(toIndex);
                    rows.set(toIndex, rows.get(fromIndex));
                    rows.set(fromIndex, obj);
                }
                this.fireTableStructureChanged();
            }
        }

        void setColumnCount(int newColumnCount) {
            ResourceBundle bundle = TableModelEditor.getBundle();
            int colCount = this.columns.size();
            if (newColumnCount == colCount) {
                return;
            }
            if (newColumnCount > colCount) {
                for (int nc = newColumnCount - colCount; nc > 0; --nc) {
                    this.columns.add(new ColumnItem(bundle.getString("CTL_Title") + " " + Integer.toString(newColumnCount - nc + 1), Object.class, true, this.rowCount));
                }
            } else {
                for (int cn = colCount - newColumnCount; cn > 0; --cn) {
                    this.columns.remove(newColumnCount + cn - 1);
                }
            }
            this.fireTableStructureChanged();
        }

        public void addColumn(int index) {
            if (index >= 0 && index <= this.columns.size()) {
                this.columns.add(index, new ColumnItem(TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(index + 1), Object.class, true, this.rowCount));
                int n = this.columns.size();
                for (int i = index + 1; i < n; ++i) {
                    ColumnItem ci = this.columns.get(i);
                    NbTableModel.renameDefaultColumnTitle(ci, i, i + 1);
                }
                this.fireTableStructureChanged();
            }
        }

        public void removeColumn(int index) {
            if (index >= 0 && index < this.columns.size()) {
                this.columns.remove(index);
                int n = this.columns.size();
                for (int i = index; i < n; ++i) {
                    ColumnItem ci = this.columns.get(i);
                    NbTableModel.renameDefaultColumnTitle(ci, i + 2, i + 1);
                }
                this.fireTableStructureChanged();
            }
        }

        public void moveColumn(int fromIndex, int toIndex) {
            if (fromIndex >= 0 && fromIndex < this.columns.size() && toIndex >= 0 && toIndex < this.columns.size() && fromIndex != toIndex) {
                ColumnItem ciFrom = this.columns.get(fromIndex);
                ColumnItem ciTo = this.columns.get(toIndex);
                NbTableModel.renameDefaultColumnTitle(ciFrom, fromIndex + 1, toIndex + 1);
                NbTableModel.renameDefaultColumnTitle(ciTo, toIndex + 1, fromIndex + 1);
                this.columns.set(toIndex, ciFrom);
                this.columns.set(fromIndex, ciTo);
                this.fireTableStructureChanged();
            }
        }

        private static void renameDefaultColumnTitle(ColumnItem ci, int fromIndex, int toIndex) {
            String fromStr = TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(fromIndex);
            if (fromStr.equals(ci.title)) {
                ci.title = TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(toIndex);
            }
        }

        @Override
        public void writeExternal(ObjectOutput oo) throws IOException {
            ColumnItem ci;
            int i;
            oo.writeInt(this.rowCount);
            int colCount = this.columns.size();
            oo.writeInt(colCount);
            String[] titles = new String[colCount];
            boolean[] editable = new boolean[colCount];
            for (i = 0; i < colCount; ++i) {
                ci = this.columns.get(i);
                titles[i] = ci.title;
                editable[i] = ci.editable;
            }
            oo.writeObject(titles);
            oo.writeObject(editable);
            for (i = 0; i < colCount; ++i) {
                ci = this.columns.get(i);
                oo.writeObject(ci.type.getName());
            }
            for (i = 0; i < this.rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    ColumnItem ci2 = this.columns.get(j);
                    if (ci2.rows.get(i) instanceof Serializable) {
                        oo.writeObject(ci2.rows.get(i));
                        continue;
                    }
                    oo.writeObject(null);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            int i;
            this.rowCount = oi.readInt();
            int colCount = oi.readInt();
            this.columns = new ArrayList<ColumnItem>(colCount);
            String[] titles = (String[])oi.readObject();
            boolean[] editable = (boolean[])oi.readObject();
            for (i = 0; i < colCount; ++i) {
                this.columns.add(new ColumnItem(titles[i], Class.forName((String)oi.readObject()), editable[i], this.rowCount));
            }
            for (i = 0; i < this.rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    ColumnItem ci = this.columns.get(j);
                    ci.rows.set(i, oi.readObject());
                }
            }
        }

        private static class ColumnItem {
            String title;
            Class type;
            boolean editable;
            List<Object> rows;

            ColumnItem(String title, Class type, boolean editable, int rowCount) {
                this.title = title;
                this.type = type;
                this.editable = editable;
                this.rows = new ArrayList<Object>(rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    this.rows.add(null);
                }
            }

            ColumnItem(String title, Class type, boolean editable, List<Object> data) {
                this.title = title;
                this.type = type;
                this.editable = editable;
                this.rows = data;
            }

            ColumnItem(ColumnItem ci) {
                this.title = ci.title;
                this.type = ci.type;
                this.editable = ci.editable;
                int rowCount = ci.rows.size();
                this.rows = new ArrayList<Object>(rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    this.rows.add(ci.rows.get(i));
                }
            }
        }
    }
}

