/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnumEditor
extends PropertyEditorSupport
implements NamedPropertyEditor,
XMLPropertyEditor {
    private Object[] enumerationValues;
    private boolean unknownToString;
    private static String[] arrangedEnumLabels = new String[]{"WindowConstants.DISPOSE_ON_CLOSE", "DISPOSE", "WindowConstants.DO_NOTHING_ON_CLOSE", "DO_NOTHING", "WindowConstants.HIDE_ON_CLOSE", "HIDE", "JFrame.EXIT_ON_CLOSE", "EXIT", "ListSelectionModel.MULTIPLE_INTERVAL_SELECTION", "MULTIPLE_INTERVAL", "ListSelectionModel.SINGLE_INTERVAL_SELECTION", "SINGLE_INTERVAL", "ListSelectionModel.SINGLE_SELECTION", "SINGLE", "JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS", "ALWAYS", "JScrollPane.HORIZONTAL_SCROLLBAR_NEVER", "NEVER", "JScrollPane.VERTICAL_SCROLLBAR_ALWAYS", "ALWAYS", "JScrollPane.VERTICAL_SCROLLBAR_NEVER", "NEVER", "JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS", "ALWAYS", "ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER", "NEVER", "ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS", "ALWAYS", "ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER", "NEVER", "ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "JTable.AUTO_RESIZE_NEXT_COLUMN", "NEXT_COLUMN", "JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS", "SUBSEQUENT_COLUMNS", "JTable.AUTO_RESIZE_OFF", "OFF", "JTable.AUTO_RESIZE_ALL_COLUMNS", "ALL_COLUMNS", "JTable.AUTO_RESIZE_LAST_COLUMN", "LAST_COLUMN"};
    private static String[] swingClassNames = new String[]{"SwingConstants.", "DebugGraphics.", "JDesktopPane.", "JFileChooser.", "WindowConstants.", "ListSelectionModel.", "JScrollBar.", "JScrollPane.", "ScrollPaneConstants.", "JSlider.", "JSplitPane.", "JTabbedPane.", "JTable.", "JTextField.", "JViewport.", "JFrame.", "JList.", "JFormattedTextField."};
    private static final String XML_VALUE = "Value";
    private static final String ATTR_ID = "id";

    public EnumEditor(Object[] enumerationValues) {
        this(enumerationValues, true, false);
    }

    public EnumEditor(Object[] enumerationValues, boolean translate) {
        this(enumerationValues, translate, false);
    }

    protected EnumEditor(Object[] enumerationValues, boolean translate, boolean unknownToString) {
        if (translate) {
            EnumEditor.translateEnumLabels(enumerationValues);
        }
        this.enumerationValues = enumerationValues;
        this.unknownToString = unknownToString;
    }

    protected Object[] getEnumerationValues() {
        return this.enumerationValues;
    }

    @Override
    public String[] getTags() {
        int n = this.enumerationValues.length / 3;
        String[] tags = new String[n];
        for (int i = 0; i < n; ++i) {
            tags[i] = (String)this.enumerationValues[i * 3];
        }
        return tags;
    }

    @Override
    public void setAsText(String str) {
        this.setValueFromString(str);
    }

    protected final boolean setValueFromString(String str) {
        int n = this.enumerationValues.length / 3;
        for (int i = 0; i < n; ++i) {
            if (!this.enumerationValues[i * 3].toString().equals(str)) continue;
            this.setValue(this.enumerationValues[i * 3 + 1]);
            return true;
        }
        return false;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        int n = this.enumerationValues.length / 3;
        for (int i = 0; i < n; ++i) {
            Object eVal = this.enumerationValues[i * 3 + 1];
            if ((eVal != null || value != null) && (eVal == null || !eVal.equals(value))) continue;
            return this.enumerationValues[i * 3].toString();
        }
        if (this.unknownToString && value != null) {
            return value.toString();
        }
        return this.enumerationValues.length > 0 ? this.enumerationValues[0].toString() : null;
    }

    @Override
    public String getJavaInitializationString() {
        int i;
        String initString = null;
        Object value = this.getValue();
        int n = this.enumerationValues.length / 3;
        for (i = 0; i < n; ++i) {
            Object eVal = this.enumerationValues[i * 3 + 1];
            if ((eVal != null || value != null) && (eVal == null || !eVal.equals(value))) continue;
            initString = (String)this.enumerationValues[i * 3 + 2];
            break;
        }
        if (initString == null) {
            if (this.unknownToString && value != null) {
                initString = value.toString();
            } else {
                String string = initString = this.enumerationValues.length > 2 ? (String)this.enumerationValues[2] : null;
            }
        }
        if (initString == null) {
            return null;
        }
        for (i = 0; i < swingClassNames.length; ++i) {
            if (!initString.startsWith(swingClassNames[i])) continue;
            initString = "javax.swing." + initString;
            break;
        }
        return initString;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getBundle(EnumEditor.class).getString("CTL_EnumEditorName");
    }

    private static void translateEnumLabels(Object[] enumerationValues) {
        int n1 = enumerationValues.length / 3;
        int n2 = arrangedEnumLabels.length / 2;
        block0: for (int i = 0; i < n1; ++i) {
            String code = (String)enumerationValues[i * 3 + 2];
            for (int j = 0; j < n2; ++j) {
                if (!code.endsWith(arrangedEnumLabels[j * 2])) continue;
                enumerationValues[i * 3] = arrangedEnumLabels[j * 2 + 1];
                continue block0;
            }
        }
    }

    public void readFromXML(Node element) throws IOException {
        NamedNodeMap attributes = element.getAttributes();
        Node node = attributes.getNamedItem(ATTR_ID);
        String id = node.getNodeValue();
        int n = this.enumerationValues.length / 3;
        for (int i = 0; i < n; ++i) {
            if (!this.enumerationValues[i * 3].toString().equals(id) && (!(this.enumerationValues[i * 3 + 1] instanceof Enum) || !((Enum)this.enumerationValues[i * 3 + 1]).name().equals(id))) continue;
            this.setValue(this.enumerationValues[i * 3 + 1]);
            break;
        }
    }

    public Node storeToXML(Document doc) {
        Object value = this.getValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof Character || value instanceof String || value instanceof Class) {
            return null;
        }
        String id = value instanceof Enum ? ((Enum)value).name() : this.getAsText();
        Element el = doc.createElement(XML_VALUE);
        el.setAttribute(ATTR_ID, id);
        return el;
    }
}

