/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class RestoreKeyFromFileRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private Long contentLength;
    private InputStream restoreKeyFromFileDetails;
    private String ifMatch;
    private String contentMd5;
    private String opcRequestId;
    private String opcRetryToken;

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getRestoreKeyFromFileDetails() {
        return this.restoreKeyFromFileDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.restoreKeyFromFileDetails;
    }

    public Builder toBuilder() {
        return new Builder().contentLength(this.contentLength).restoreKeyFromFileDetails(this.restoreKeyFromFileDetails).ifMatch(this.ifMatch).contentMd5(this.contentMd5).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",contentLength=").append(String.valueOf(this.contentLength));
        sb.append(",restoreKeyFromFileDetails=").append(String.valueOf(this.restoreKeyFromFileDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",contentMd5=").append(String.valueOf(this.contentMd5));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestoreKeyFromFileRequest)) {
            return false;
        }
        RestoreKeyFromFileRequest other = (RestoreKeyFromFileRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.contentLength, other.contentLength) && Objects.equals(this.restoreKeyFromFileDetails, other.restoreKeyFromFileDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.contentMd5, other.contentMd5) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentLength == null ? 43 : this.contentLength.hashCode());
        result = result * 59 + (this.restoreKeyFromFileDetails == null ? 43 : this.restoreKeyFromFileDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.contentMd5 == null ? 43 : this.contentMd5.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreKeyFromFileRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private Long contentLength = null;
        private InputStream restoreKeyFromFileDetails = null;
        private String ifMatch = null;
        private String contentMd5 = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder restoreKeyFromFileDetails(InputStream restoreKeyFromFileDetails) {
            this.restoreKeyFromFileDetails = restoreKeyFromFileDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder contentMd5(String contentMd5) {
            this.contentMd5 = contentMd5;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreKeyFromFileRequest o) {
            this.contentLength(o.getContentLength());
            this.restoreKeyFromFileDetails(o.getRestoreKeyFromFileDetails());
            this.ifMatch(o.getIfMatch());
            this.contentMd5(o.getContentMd5());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreKeyFromFileRequest build() {
            RestoreKeyFromFileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.restoreKeyFromFileDetails(body);
            return this;
        }

        public RestoreKeyFromFileRequest buildWithoutInvocationCallback() {
            RestoreKeyFromFileRequest request = new RestoreKeyFromFileRequest();
            request.contentLength = this.contentLength;
            request.restoreKeyFromFileDetails = this.restoreKeyFromFileDetails;
            request.ifMatch = this.ifMatch;
            request.contentMd5 = this.contentMd5;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

