/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.Name;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.jdk.CheckRegexTopComponent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class CheckRegex {
    @CheckForNull
    public static ErrorDescription computeWarning(HintContext ctx) {
        String originalString = null;
        Tree leaf = ((TreePath)ctx.getVariables().get("$pattern")).getLeaf();
        if (leaf.getKind() == Tree.Kind.STRING_LITERAL) {
            originalString = (String)((LiteralTree)leaf).getValue();
        } else if (leaf.getKind() == Tree.Kind.IDENTIFIER) {
            originalString = CheckRegex.identifierSearch(leaf, ctx);
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_CheckRegex(), (Fix[])new Fix[]{new FixImpl(ctx.getInfo(), ctx.getPath(), originalString).toEditorFix()});
    }

    @CheckForNull
    public static String identifierSearch(Tree leaf, HintContext ctx) {
        TreePath tp;
        String originalString = null;
        Name name = ((IdentifierTree)leaf).getName();
        Tree statement = tp.getLeaf();
        BlockTree bt = null;
        for (tp = ctx.getPath().getParentPath(); originalString == null && tp != null; tp = tp.getParentPath()) {
            Tree tree = tp.getLeaf();
            if (tree instanceof BlockTree) {
                BlockTree blockTree = (BlockTree)tree;
                originalString = CheckRegex.identifierBlockSearch(tp.getLeaf(), name, statement, bt);
                bt = blockTree;
                continue;
            }
            tree = tp.getLeaf();
            if (!(tree instanceof ClassTree)) continue;
            ClassTree ct = (ClassTree)tree;
            originalString = CheckRegex.identifierClassSearch(ct, name);
        }
        return originalString;
    }

    @CheckForNull
    private static String identifierBlockSearch(Tree leaf, Name name, Tree statement, BlockTree blocktree) {
        String res = null;
        try {
            BlockTree bt = (BlockTree)leaf;
            List<? extends StatementTree> statements = bt.getStatements();
            for (int i = 0; i < statements.size(); ++i) {
                AssignmentTree at;
                ExpressionStatementTree est;
                ExpressionTree expressionTree;
                StatementTree st = statements.get(i);
                if (st.equals(statement)) {
                    return res;
                }
                if (st.equals(blocktree)) {
                    return res;
                }
                if (st instanceof VariableTree) {
                    VariableTree vt = (VariableTree)st;
                    if (!vt.getType().toString().equalsIgnoreCase("String") || !vt.getName().equals(name)) continue;
                    LiteralTree lt = (LiteralTree)vt.getInitializer();
                    res = (String)lt.getValue();
                    continue;
                }
                if (!(st instanceof ExpressionStatementTree) || !((expressionTree = (est = (ExpressionStatementTree)st).getExpression()) instanceof AssignmentTree) || !(at = (AssignmentTree)expressionTree).getVariable().toString().equals(name.toString())) continue;
                res = (String)((LiteralTree)at.getExpression()).getValue();
            }
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    @CheckForNull
    private static String identifierClassSearch(ClassTree ct, Name name) {
        String res = null;
        try {
            List<? extends Tree> members = ct.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                AssignmentTree at;
                ExpressionStatementTree est;
                ExpressionTree expressionTree;
                Tree t = members.get(i);
                if (t instanceof VariableTree) {
                    VariableTree vt = (VariableTree)t;
                    if (!vt.getType().toString().equalsIgnoreCase("String") || !vt.getName().equals(name)) continue;
                    LiteralTree lt = (LiteralTree)vt.getInitializer();
                    res = lt != null ? (String)lt.getValue() : null;
                    continue;
                }
                if (!(t instanceof ExpressionStatementTree) || !((expressionTree = (est = (ExpressionStatementTree)t).getExpression()) instanceof AssignmentTree) || !(at = (AssignmentTree)expressionTree).getVariable().toString().equals(name.toString())) continue;
                res = (String)((LiteralTree)at.getExpression()).getValue();
            }
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    private static final class FixImpl
    extends JavaFix {
        private final String origString;

        private FixImpl(CompilationInfo info, TreePath path, String origString) {
            super(info, path);
            this.origString = origString;
        }

        protected String getText() {
            return Bundle.DESC_CheckRegex();
        }

        protected void performRewrite(JavaFix.TransformationContext tc) throws Exception {
            SwingUtilities.invokeLater(() -> {
                CheckRegexTopComponent win = CheckRegexTopComponent.findInstance();
                win.open();
                win.requestActive();
                win.setData(this.origString);
            });
        }
    }
}

