macro(add_plugin plugin_dir plugin_name)
    add_subdirectory(${plugin_dir})
    get_property(PLUGIN_DISABLED GLOBAL PROPERTY "DISABLE_${plugin_name}")
    if (NOT PLUGIN_DISABLED STREQUAL "true")
        message(STATUS "[add-plugin] ${BoldGreen}added ${plugin_name}${ColorReset}")
        add_dependencies(musikcube ${plugin_name})
        add_dependencies(musikcubed ${plugin_name})
        add_dependencies(core_c_demo ${plugin_name})
    else()
        message(STATUS "[add-plugin] ${BoldRed}skipped ${plugin_name}${ColorReset}")
    endif()
endmacro(add_plugin)

macro(disable_plugin plugin_name)
    set(PROPERTY_NAME "DISABLE_${plugin_name}")
    set_property(GLOBAL PROPERTY ${PROPERTY_NAME} "true")
    get_property(PLUGIN_DISABLED GLOBAL PROPERTY "DISABLE_${plugin_name}")
endmacro(disable_plugin)
