/**
 * Copyright (C) 2022 MongoDB, Inc.  All Rights Reserved.
 */

#pragma once

#include "mongo/db/pipeline/expression_context.h"
#include "mongo/db/pipeline/search_helper.h"
#include "mongo/executor/task_executor_cursor.h"

namespace mongo::mongot_cursor {

/**
 * A class that contains methods that are implemented as stubs in community that need to be
 * overridden.
 */
class SearchImplementedHelperFunctions : public SearchDefaultHelperFunctions {
public:
    boost::optional<std::string> validatePipelineForShardedCollection(
        const Pipeline& pipeline) override final;
};

/**
 * Invoke planShardedSearch on the remote mongot. Ignore the result and throw on a non-OK status.
 * This is because on v5.0 and below, we use mongot for query validation.
 */
void planShardedSearch(const ExpressionContext& expCtx, const BSONObj& searchRequest);

}  // namespace mongo::mongot_cursor
