/**
 *  Copyright (C) 2016 MongoDB Inc.
 */

#define MONGO_LOGV2_DEFAULT_COMPONENT ::mongo::logv2::LogComponent::kAccessControl

#include "mongo/platform/basic.h"

#include "ldap_manager.h"

#include <memory>

#include "mongo/base/init.h"
#include "mongo/db/service_context.h"
#include "mongo/logv2/log.h"

namespace mongo {

namespace {
const auto getLDAPManager = ServiceContext::declareDecoration<std::unique_ptr<LDAPManager>>();
static bool inStartupCheck = true;
}  // namespace

void LDAPManager::set(ServiceContext* service, std::unique_ptr<LDAPManager> ldapManager) {
    auto& manager = getLDAPManager(service);
    invariant(ldapManager);
    manager = std::move(ldapManager);
}

LDAPManager* LDAPManager::get(ServiceContext* service) {
    return getLDAPManager(service).get();
}

bool LDAPManager::isInStartupCheck() {
    return inStartupCheck;
}
void LDAPManager::setInStartupCheck(bool check) {
    inStartupCheck = check;
    if (!check) {
        LOGV2(5945604, "LDAP startup complete");
    }
}

}  // namespace mongo
